/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LitterBoxBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61418_;
    protected static final VoxelShape X_AXIS_AABB = LitterBoxBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)14.0);
    protected static final VoxelShape Z_AXIS_AABB = LitterBoxBlock.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0);

    public LitterBoxBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(0.2f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public void setLevel(Level world, BlockPos pos, BlockState state, int level) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level)), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack itemStack = player.m_21120_(hand);
        int level = (Integer)state.m_61143_((Property)LEVEL);
        if (level == 1) {
            if (itemStack.m_41720_() != Blocks.f_49992_.m_5456_()) {
                return InteractionResult.PASS;
            }
            this.setLevel(world, pos, state, 2);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        } else if (level == 2) {
            if (itemStack.m_41720_() == Items.f_42500_) {
                this.setLevel(world, pos, state, 3);
            } else {
                ItemStack returnSand = new ItemStack((ItemLike)Blocks.f_49992_);
                if (!player.m_7500_()) {
                    if (itemStack.m_41619_()) {
                        player.m_21008_(hand, returnSand);
                    } else if (!player.m_36356_(returnSand)) {
                        player.m_36176_(returnSand, false);
                    }
                }
                this.setLevel(world, pos, state, 1);
            }
        } else {
            if (itemStack.m_41720_() != Blocks.f_49992_.m_5456_()) {
                return InteractionResult.PASS;
            }
            this.setLevel(world, pos, state, 2);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)direction);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state.m_60734_() != this ? state : (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{FACING, LEVEL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }
}

