/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatTreeBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected final VoxelShape voxelShape;

    public CatTreeBlock(VoxelShape axisAlignedBB) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_280658_(NoteBlockInstrument.GUITAR).m_60978_(0.8f).m_60918_(SoundType.f_56745_));
        this.voxelShape = axisAlignedBB;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return entity instanceof SimplyCatEntity;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return this.voxelShape;
    }

    public static class Bed
    extends Facing {
        protected static final VoxelShape AABB_BOTTOM = Bed.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

        public Bed(VoxelShape voxelShape) {
            super(voxelShape);
        }

        @Override
        public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
            return AABB_BOTTOM;
        }
    }

    public static class Box
    extends Facing {
        private static final VoxelShape INSIDE_NS = Box.m_49796_((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
        public static final VoxelShape INSIDE_EW = Box.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
        protected static final VoxelShape NORTH_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83110_((VoxelShape)Box.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)INSIDE_NS), (BooleanOp)BooleanOp.f_82685_);
        protected static final VoxelShape EAST_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83110_((VoxelShape)Box.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_EW), (BooleanOp)BooleanOp.f_82685_);
        protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83110_((VoxelShape)Box.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_NS), (BooleanOp)BooleanOp.f_82685_);
        protected static final VoxelShape WEST_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83110_((VoxelShape)Box.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (VoxelShape)INSIDE_EW), (BooleanOp)BooleanOp.f_82685_);

        public Box() {
            super(Shapes.m_83144_());
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            switch (direction) {
                default: {
                    return NORTH_SHAPE;
                }
                case EAST: {
                    return EAST_SHAPE;
                }
                case SOUTH: {
                    return SOUTH_SHAPE;
                }
                case WEST: 
            }
            return WEST_SHAPE;
        }

        public VoxelShape m_6079_(BlockState state, BlockGetter blockReader, BlockPos pos) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            return direction.m_122434_() == Direction.Axis.X ? INSIDE_NS : INSIDE_EW;
        }
    }

    public static class Facing
    extends CatTreeBlock {
        public Facing(VoxelShape axisAlignedBB) {
            super(axisAlignedBB);
            this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        }

        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction direction = context.m_8125_().m_122424_();
            return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)direction);
        }

        public BlockState m_6843_(BlockState state, Rotation rotation) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
            blockStateBuilder.m_61104_(new Property[]{FACING});
        }
    }
}

