/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.world.structure;

import com.auviotre.makit_better.init.MKBStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class MeteoriteCraterStructure
extends Structure {
    public static final Codec<MeteoriteCraterStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MeteoriteCraterStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, MeteoriteCraterStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    protected MeteoriteCraterStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int distance) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = distance;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int minX = chunkpos.m_45604_();
        int minZ = chunkpos.m_45605_();
        int mX = chunkpos.m_151390_();
        int mZ = chunkpos.m_151393_();
        int[] height = new int[]{context.f_226622_().m_223235_(minX + 1, minZ + 1, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()), context.f_226622_().m_223235_(minX + 1, minZ + 14, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()), context.f_226622_().m_223235_(minX + 14, minZ + 1, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()), context.f_226622_().m_223235_(minX + 14, minZ + 14, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()), context.f_226622_().m_223235_(mX, mZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_())};
        int[] delta = new int[]{height[0] - height[1], height[0] - height[2], height[0] - height[3], height[1] - height[2], height[1] - height[3], height[2] - height[3], height[4] - height[0], height[4] - height[1], height[4] - height[2], height[4] - height[3], 0};
        for (int i = 0; i < 10; ++i) {
            if (Math.abs(delta[i]) <= delta[10]) continue;
            delta[10] = Math.abs(delta[i]);
        }
        return delta[10] < 2;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!MeteoriteCraterStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)MKBStructures.METEORITE_CRATER.get();
    }
}

