/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.util;

import com.auviotre.makit_better.entities.projectile.RoseArrow;
import com.auviotre.makit_better.entities.projectile.SnowballWithStone;
import com.auviotre.makit_better.entities.projectile.SoulBoneArrow;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.items.BloodVesselItem;
import com.auviotre.makit_better.items.BreathingBagItem;
import com.auviotre.makit_better.items.CoralWhisperItem;
import com.auviotre.makit_better.items.TideChainItem;
import net.minecraft.Util;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.registries.RegistryObject;

public class MKBItemProperties {
    public static void init() {
        MKBItemProperties.addItemProperties();
        MKBItemProperties.initDispenser();
    }

    public static void addItemProperties() {
        MKBItemProperties.registerBowResourceLocations(MKBItems.ROSE_TEAR);
        MKBItemProperties.registerThrownResourceLocations(MKBItems.TITANDENT);
        MKBItemProperties.registerFillResourceLocations(MKBItems.BLOOD_VESSEL);
        MKBItemProperties.registerCastResourceLocations(MKBItems.CORAL_WHISPER);
        MKBItemProperties.registerFilledResourceLocations(MKBItems.BREATHING_BAG);
        MKBItemProperties.registerBowResourceLocations(MKBItems.ASTRO_SHATTERING);
        MKBItemProperties.registerThrownOutResourceLocations(MKBItems.TIDE_CHAIN);
        MKBItemProperties.registerBlockingResourceLocations(MKBItems.SOUL_SHIELD);
        MKBItemProperties.registerBlockingResourceLocations(MKBItems.CORAL_SHIELD);
    }

    public static void registerBowResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, level, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, level, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerThrownResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("throwing"), (itemStack, level, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerThrownOutResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("chain_out"), (itemStack, level, livingEntity, i) -> TideChainItem.getChainOutCount(itemStack));
    }

    public static void registerFillResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("filling"), (itemStack, level, livingEntity, i) -> BloodVesselItem.getFilling(itemStack) / 20.0f);
    }

    public static void registerFilledResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("filled"), (itemStack, level, livingEntity, i) -> BreathingBagItem.Filled(itemStack) ? 1.0f : 0.0f);
    }

    public static void registerBlockingResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("blocking"), (itemStack, level, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerCastResourceLocations(RegistryObject<Item> item) {
        ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)new ResourceLocation("cast"), (itemStack, clientLevel, livingEntity, i) -> {
            boolean flag1;
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean flag = livingEntity.m_21205_() == itemStack;
            boolean bl = flag1 = livingEntity.m_21206_() == itemStack;
            if (livingEntity.m_21205_().m_41720_() instanceof CoralWhisperItem) {
                flag1 = false;
            }
            return (flag || flag1) && livingEntity instanceof Player && ((Player)livingEntity).f_36083_ != null ? 1.0f : 0.0f;
        });
    }

    public static void initDispenser() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)MKBItems.ROSE_ARROW.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                RoseArrow arrow = new RoseArrow(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)MKBItems.SOUL_BONE_ARROW.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                SoulBoneArrow arrow = new SoulBoneArrow(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)MKBItems.SNOWBALL_WITH_STONE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                return (Projectile)Util.m_137469_((Object)((Object)new SnowballWithStone(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), snowballWithStone -> snowballWithStone.m_37446_(stackIn));
            }
        });
    }
}

