/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.mixin;

import com.auviotre.makit_better.init.MKBEffects;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.init.MKBParticleTypes;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgePlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IForgePlayer {
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    public abstract boolean m_21219_();

    @Shadow
    public abstract boolean m_6117_();

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"hasEffect"}, at={@At(value="RETURN")}, cancellable=true)
    private void hasEffectAbyss(MobEffect effect, CallbackInfoReturnable<Boolean> cir) {
        if (effect.equals(MobEffects.f_19592_)) {
            cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false || this.f_20945_.containsKey(MKBEffects.ANCIENT_ABYSS_POWER.get()) ? 1 : 0));
        }
    }

    @Inject(method={"getEffect"}, at={@At(value="RETURN")}, cancellable=true)
    private void getEffectAbyss(MobEffect effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        if (effect.equals(MobEffects.f_19592_) && !this.f_20945_.containsKey(effect)) {
            cir.setReturnValue((Object)this.f_20945_.get(MKBEffects.ANCIENT_ABYSS_POWER.get()));
        }
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        if (!source.m_269533_(DamageTypeTags.f_268738_)) {
            ItemStack itemstack2 = null;
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack1 = this.m_21120_(interactionhand);
                if (!itemstack1.m_150930_((Item)MKBItems.BLOOD_VESSEL_FILLED.get())) continue;
                itemstack2 = itemstack1.m_41777_();
                itemstack1.m_41774_(1);
                break;
            }
            if (itemstack2 != null) {
                this.m_21153_(1.0f);
                this.m_21219_();
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, 4));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 50, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 0));
                this.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.SANGUINARY_THIRST.get(), 800, 2));
                this.m_9236_().m_7605_((Entity)this, (byte)35);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="TAIL")})
    public void handleEntityEvent(byte event, CallbackInfo ci) {
        switch (event) {
            case -36: {
                double BBx = this.m_20191_().m_82362_();
                double BBy = this.m_20191_().m_82376_();
                double BBz = this.m_20191_().m_82385_();
                double R = Math.min(Math.sqrt(BBx * BBx + BBz * BBz), 4.0);
                int i = 0;
                while ((double)i < 4.0 * R) {
                    double dx = this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * BBx;
                    double dy = this.m_20186_() + (double)this.f_19796_.m_188501_() * BBy;
                    double dz = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * BBz;
                    double speedx = (dx - this.m_20185_()) * 0.1;
                    double speedy = (dy - this.m_20186_()) * 0.1;
                    double speedz = (dz - this.m_20189_()) * 0.1;
                    this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.STAR_DUST.get(), dx, dy, dz, speedx, speedy / 2.0, speedz);
                    ++i;
                }
                for (double i2 = 0.0; i2 < 24.0; i2 += 1.0) {
                    double py = this.m_20186_() + BBy * 0.2;
                    double dx = R * Math.cos((double)((float)(i2 / 12.0)) * Math.PI) * 0.5;
                    double dy = (double)this.f_19796_.m_188501_() * 0.02 - 0.002;
                    double dz = R * Math.sin((double)((float)(i2 / 12.0)) * Math.PI) * 0.5;
                    this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.STAR_DUST.get(), this.m_20185_(), py, this.m_20189_(), dx, dy, dz);
                }
                break;
            }
            case -37: {
                for (int i = 0; i < 12; ++i) {
                    double dx = this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f) * this.m_20191_().m_82362_();
                    double dy = this.m_20186_() + (double)this.f_19796_.m_188501_() * this.m_20191_().m_82376_();
                    double dz = this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f) * this.m_20191_().m_82385_();
                    double speedx = (dx - this.m_20185_()) * 0.08;
                    double speedy = (double)this.f_19796_.m_188501_() * 0.04;
                    double speedz = (dz - this.m_20189_()) * 0.08;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, dx, dy, dz, speedx, speedy, speedz);
                    this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.SOUL_DROPLET.get(), dx, dy, dz, speedx, speedy / 3.0, speedz);
                }
                break;
            }
        }
    }
}

