/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.items;

import com.auviotre.makit_better.entities.projectile.PrismarineFragment;
import com.auviotre.makit_better.init.MKBSounds;
import com.auviotre.makit_better.items.properities.MKBItemTiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TideChainItem
extends SwordItem {
    private boolean chargedSound = true;

    public TideChainItem(int dmgModifier, float spdModifier, Item.Properties properties) {
        super((Tier)MKBItemTiers.PRISMARINE, dmgModifier, spdModifier, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (TideChainItem.canBeThrown(itemstack)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int time) {
        float f;
        if (!level.f_46443_ && (f = TideChainItem.getPowerForTime(this.m_8105_(stack) - time, stack)) >= 1.0f && this.chargedSound) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11743_, SoundSource.NEUTRAL, 1.0f, 0.5f);
            this.chargedSound = false;
        }
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int time) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float f = TideChainItem.getPowerForTime(this.m_8105_(itemStack) - time, itemStack);
            if (f >= 1.0f) {
                TideChainItem.setChainOutCount(itemStack, 3);
                this.chargedSound = true;
                InteractionHand hand = player.m_7655_();
                for (int i = 0; i < 3; ++i) {
                    PrismarineFragment fragment = new PrismarineFragment(level, (LivingEntity)player, itemStack, hand);
                    fragment.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.7f * f + (float)i * 0.5f + (float)(i * i) * 0.05f, 0.0f);
                    Vec3 delta = fragment.m_20184_();
                    fragment.m_20256_(delta.m_82524_(hand == InteractionHand.MAIN_HAND ? 0.035f : -0.035f));
                    fragment.renderYRotO = (float)(Mth.m_14136_((double)delta.f_82481_, (double)delta.f_82479_) * 57.2957763671875) - 90.0f;
                    level.m_7967_((Entity)fragment);
                }
                itemStack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)MKBSounds.TIDE_CHAIN_MOVE.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.5f + 1.0f) + 0.6f);
            }
        }
    }

    public static boolean canBeThrown(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128451_("ChainOutCount") == 0;
    }

    public static int getChainOutCount(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("ChainOutCount") : -1;
    }

    public static void setChainOutCount(ItemStack itemStack, int num) {
        CompoundTag compoundtag = itemStack.m_41784_();
        compoundtag.m_128405_("ChainOutCount", num);
    }

    private static float getPowerForTime(int time, ItemStack stack) {
        float f = (float)time / 12.0f;
        return Math.min(f, 1.08f);
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44981_;
    }
}

