/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.items;

import com.auviotre.makit_better.entities.animated.AnimatedEntity;
import com.auviotre.makit_better.items.properities.MKBItemTiers;
import com.auviotre.makit_better.tags.MKBTags;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GreedistItem
extends SwordItem {
    public static UUID BASE_ATTACK_DAMAGE_UUID = Item.f_41374_;
    public static UUID BASE_ATTACK_SPEED_UUID = Item.f_41375_;

    public GreedistItem(Item.Properties properties) {
        super((Tier)MKBItemTiers.GREEDIST, 2, -3.0f, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        float percent = GreedistItem.getLevel(stack) * 10.0f;
        super.m_7373_(stack, level, list, flag);
        list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".desc"), (Object[])new Object[]{(int)percent}).m_130940_(ChatFormatting.GOLD));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21205_();
        ItemStack offStack = player.m_21206_();
        float price = 0.0f;
        if (offStack.m_204117_(MKBTags.CHEAP_ITEM)) {
            price = 0.8f;
        } else if (offStack.m_204117_(MKBTags.NORMAL_ITEM)) {
            price = 1.6f;
        } else if (offStack.m_204117_(MKBTags.EXPANSIVE_ITEM)) {
            price = 4.0f;
        }
        float index = GreedistItem.getLevel(itemStack);
        if (itemStack.m_41720_() instanceof GreedistItem && GreedistItem.isNotTop(itemStack) && price > 0.0f) {
            float indexPost = index + player.m_217043_().m_188501_() * 0.2f * price;
            if (level.f_46443_) {
                if (Mth.m_14143_((float)(indexPost * 10.0f)) != Mth.m_14143_((float)(index * 10.0f))) {
                    level.m_6269_(player, (Entity)player, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.8f, 1.1f + 0.2f * player.m_217043_().m_188501_());
                }
            } else {
                GreedistItem.setLevel(itemStack, indexPost);
                if (!player.m_150110_().f_35937_) {
                    offStack.m_41774_(1);
                }
                if ((double)player.m_217043_().m_188501_() > 0.95) {
                    itemStack.m_41742_(itemStack.m_41610_() + 1);
                }
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (Screen.m_96638_()) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), 300 - Mth.m_14143_((float)(index * 10.0f)));
            if (level.f_46443_) {
                Vec3 look = player.m_20154_();
                look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
                for (int i = -30; i <= 30; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        float angle = (float)i / 90.0f * (float)Math.PI + (float)Math.random() * 0.2f;
                        Vec3 speed = look.m_82524_(angle).m_82490_(Math.random() * 1.5 + 0.6);
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123767_, player.m_20185_(), player.m_20227_(0.75 + Math.random() * 0.05), player.m_20189_(), speed.f_82479_, speed.f_82480_, speed.f_82481_);
                        if (!(Math.random() > 0.8)) continue;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_(), player.m_20227_(0.55 + Math.random() * 0.05), player.m_20189_(), speed.f_82479_ / 5.0, speed.f_82480_ / 5.0, speed.f_82481_ / 5.0);
                    }
                }
                level.m_6269_(player, (Entity)player, SoundEvents.f_12513_, SoundSource.PLAYERS, 0.5f, 1.8f + 0.2f * player.m_217043_().m_188501_());
            } else {
                List entities = level.m_45933_((Entity)player, player.m_20191_().m_82400_(4.0));
                for (Entity target : entities) {
                    DamageSource source;
                    if (target.m_20147_()) continue;
                    float entityHitAngle = (float)AnimatedEntity.getAngleBetweenEntities((Entity)player, target);
                    float entityAttackingAngle = player.f_19859_ % 360.0f - 180.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    float entityHitDistance = player.m_20270_(target);
                    if (!(entityRelativeAngle <= 60.0f) || !(entityRelativeAngle >= -60.0f) || !(target instanceof LivingEntity)) continue;
                    LivingEntity entity = (LivingEntity)target;
                    entity.m_246865_(entity.m_20182_().m_82546_(player.m_20182_()).m_82490_((double)(1.25f / entityHitDistance)).m_82549_(new Vec3(0.0, 0.25, 0.0)));
                    float dmg = index * index / 8.0f + 10.0f;
                    if (dmg > entity.m_21223_() && entity.m_21223_() > 3.0f) {
                        source = player.m_269291_().m_269425_();
                        entity.m_6469_(source, entity.m_21223_() - 3.0f);
                        this.exLoot(entity, player, source);
                        continue;
                    }
                    source = player.m_269291_().m_269333_((LivingEntity)player);
                    entity.m_6469_(source, dmg / 2.0f);
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private void exLoot(LivingEntity entity, Player player, DamageSource source) {
        ResourceLocation resourcelocation = entity.m_5743_();
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server == null || !player.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        LootTable loottable = server.m_278653_().m_278676_(resourcelocation);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287289_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)source.m_7640_());
        builder = builder.m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_() * 2.0f + 1.0f);
        LootParams lootparams = builder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287276_(lootparams, entity.m_287233_(), arg_0 -> ((LivingEntity)entity).m_19983_(arg_0));
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity owner) {
        itemStack.m_41622_(1, owner, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        if (owner.m_217043_().m_188501_() > 0.8f) {
            GreedistItem.setLevel(itemStack, GreedistItem.getLevel(itemStack) - owner.m_217043_().m_188501_() * 0.2f);
        }
        if (entity instanceof Villager || entity instanceof Raider) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, entity.m_217043_().m_188503_(4));
            ItemEntity itemEntity = new ItemEntity(owner.m_9236_(), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), stack);
            itemEntity.m_32060_();
            owner.m_9236_().m_7967_((Entity)itemEntity);
        }
        return true;
    }

    public static boolean isNotTop(ItemStack itemStack) {
        return GreedistItem.getLevel(itemStack) < 10.0f;
    }

    public static float getLevel(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null ? compoundtag.m_128457_("GreedLevel") : 0.0f;
    }

    public static void setLevel(ItemStack itemStack, float num) {
        CompoundTag compoundtag = itemStack.m_41784_();
        float index = Math.min(num, 10.0f);
        compoundtag.m_128350_("GreedLevel", index);
    }
}

