/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.init;

import com.auviotre.makit_better.init.MKBConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class MKBPlacedFeatures {
    public static final ResourceKey<PlacedFeature> BLACKBLOOD_PLACED_KEY = MKBPlacedFeatures.createKey("blackblood_ore_placed");
    public static final ResourceKey<PlacedFeature> TITANIUM_PLACED_KEY = MKBPlacedFeatures.createKey("titanium_ore_placed");
    public static final ResourceKey<PlacedFeature> TITANIUM_LARGE_PLACED_KEY = MKBPlacedFeatures.createKey("titanium_ore_large_placed");
    public static final ResourceKey<PlacedFeature> SOUL_VALLEY_BERRY_PLACED_KEY = MKBPlacedFeatures.createKey("wild_soul_berry_bush_placed");
    public static final ResourceKey<PlacedFeature> CRYSTALLIZED_SOUL_SOIL_PLACED_KEY = MKBPlacedFeatures.createKey("crystallized_soul_soil_placed");
    public static final ResourceKey<PlacedFeature> NITRIFIED_NETEHRRACK_PLACED_KEY = MKBPlacedFeatures.createKey("nitrified_netherrack_placed");
    public static final ResourceKey<PlacedFeature> MOLTEN_NETEHRRACK_PLACED_KEY = MKBPlacedFeatures.createKey("molten_netherrack_placed");
    public static final ResourceKey<PlacedFeature> VOID_CONDENSATION_PLACED_KEY = MKBPlacedFeatures.createKey("void_condensation_place");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.m_255420_(Registries.f_256911_);
        MKBPlacedFeatures.register(context, BLACKBLOOD_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.BLACKBLOOD_ORE_KEY), MKBOrePlacement.rareOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        MKBPlacedFeatures.register(context, TITANIUM_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.OVERWORLD_TITANIUM_ORE_KEY), MKBOrePlacement.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-16), (VerticalAnchor)VerticalAnchor.m_158930_((int)64))));
        MKBPlacedFeatures.register(context, TITANIUM_LARGE_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.OVERWORLD_TITANIUM_ORE_LARGE_KEY), MKBOrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-16), (VerticalAnchor)VerticalAnchor.m_158930_((int)48))));
        MKBPlacedFeatures.register(context, SOUL_VALLEY_BERRY_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.SOUL_VALLEY_BERRY_KEY), MKBOrePlacement.rareOrePlacement(2, PlacementUtils.f_195356_));
        MKBPlacedFeatures.register(context, CRYSTALLIZED_SOUL_SOIL_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.CRYSTALLIZE_SOUL_SOIL_KEY), MKBOrePlacement.commonOrePlacement(6, PlacementUtils.f_195357_));
        MKBPlacedFeatures.register(context, NITRIFIED_NETEHRRACK_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.NITRIFIED_NETEHRRACK_KEY), MKBOrePlacement.commonOrePlacement(16, PlacementUtils.f_195357_));
        MKBPlacedFeatures.register(context, MOLTEN_NETEHRRACK_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.MOLTEN_NETEHRRACK_KEY), MKBOrePlacement.commonOrePlacement(16, PlacementUtils.f_195358_));
        MKBPlacedFeatures.register(context, VOID_CONDENSATION_PLACED_KEY, holdergetter.m_255043_(MKBConfiguredFeatures.VOID_CONDENSATION_KEY), MKBOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-32), (VerticalAnchor)VerticalAnchor.m_158922_((int)48))));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return MKBPlacedFeatures.createCompatKey("makit_better", name);
    }

    private static ResourceKey<PlacedFeature> createCompatKey(String ModId, String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation(ModId, name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configured, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configured, List.copyOf(modifiers)));
    }

    static class MKBOrePlacement {
        MKBOrePlacement() {
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier2) {
            return List.of(modifier, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
            return MKBOrePlacement.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
        }

        private static List<PlacementModifier> rareOrePlacement(int num, PlacementModifier modifier) {
            return MKBOrePlacement.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)num), modifier);
        }
    }
}

