/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.init;

import com.auviotre.makit_better.init.MKBBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class MKBConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKBLOOD_ORE_KEY = MKBConfiguredFeatures.registerKey("blackblood_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_TITANIUM_ORE_KEY = MKBConfiguredFeatures.registerKey("titanium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_TITANIUM_ORE_LARGE_KEY = MKBConfiguredFeatures.registerKey("titanium_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOUL_VALLEY_BERRY_KEY = MKBConfiguredFeatures.registerKey("wild_soul_berry_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRYSTALLIZE_SOUL_SOIL_KEY = MKBConfiguredFeatures.registerKey("crystallized_soul_soil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NITRIFIED_NETEHRRACK_KEY = MKBConfiguredFeatures.registerKey("nitrified_netherrack");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOLTEN_NETEHRRACK_KEY = MKBConfiguredFeatures.registerKey("molten_netherrack");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VOID_CONDENSATION_KEY = MKBConfiguredFeatures.registerKey("void_condensation");

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return MKBConfiguredFeatures.registerCompatKey("makit_better", name);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerCompatKey(String ModId, String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation(ModId, name));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplace = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplace = new TagMatchTest(BlockTags.f_144267_);
        BlockMatchTest soulSoilReplace = new BlockMatchTest(Blocks.f_50136_);
        BlockMatchTest netherrackReplace = new BlockMatchTest(Blocks.f_50134_);
        BlockMatchTest endStoneReplace = new BlockMatchTest(Blocks.f_50259_);
        MKBConfiguredFeatures.register(context, BLACKBLOOD_ORE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplace, ((Block)MKBBlocks.BLACKBLOOD_ORE.get()).m_49966_(), 4));
        MKBConfiguredFeatures.register(context, OVERWORLD_TITANIUM_ORE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)deepslateReplace, ((Block)MKBBlocks.DEEPSLATE_TITANIUM_ORE.get()).m_49966_(), 6, 0.25f));
        MKBConfiguredFeatures.register(context, OVERWORLD_TITANIUM_ORE_LARGE_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)deepslateReplace, ((Block)MKBBlocks.DEEPSLATE_TITANIUM_ORE.get()).m_49966_(), 9, 0.5f));
        MKBConfiguredFeatures.register(context, SOUL_VALLEY_BERRY_KEY, Feature.f_65763_, new RandomPatchConfiguration(16, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MKBBlocks.WILD_SOUL_BERRY_BUSH.get()))))));
        MKBConfiguredFeatures.register(context, CRYSTALLIZE_SOUL_SOIL_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)soulSoilReplace, ((Block)MKBBlocks.CRYSTALLIZED_SOUL_SOIL.get()).m_49966_(), 7));
        MKBConfiguredFeatures.register(context, NITRIFIED_NETEHRRACK_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)netherrackReplace, ((Block)MKBBlocks.NITRIFIED_NETEHRRACK.get()).m_49966_(), 6));
        MKBConfiguredFeatures.register(context, MOLTEN_NETEHRRACK_KEY, Feature.f_65731_, new OreConfiguration((RuleTest)netherrackReplace, ((Block)MKBBlocks.MOLTEN_NETEHRRACK.get()).m_49966_(), 3));
        MKBConfiguredFeatures.register(context, VOID_CONDENSATION_KEY, Feature.f_159727_, new OreConfiguration((RuleTest)endStoneReplace, ((Block)MKBBlocks.VOID_CONDENSATION.get()).m_49966_(), 2, 1.0f));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

