/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.events;

import com.auviotre.makit_better.compat.CompatHandler;
import com.auviotre.makit_better.compat.twilightforest.TFCompats;
import com.auviotre.makit_better.entities.projectile.CoralArrow;
import com.auviotre.makit_better.init.MKBEffects;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.items.BloodVesselItem;
import com.auviotre.makit_better.items.SoulShieldItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.init.TFSounds;

@Mod.EventBusSubscriber(modid="makit_better")
public class EntityEvents {
    private static boolean hasArmor(LivingEntity entity, RegistryObject<Item> item) {
        for (ItemStack armor : entity.m_6168_()) {
            if (!armor.m_41720_().equals(item.get())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker.m_21023_((MobEffect)MKBEffects.POWER_OF_RESENTMENT.get())) {
                attacker.m_21195_((MobEffect)MKBEffects.POWER_OF_RESENTMENT.get());
            }
            if (EntityEvents.hasArmor(living, MKBItems.ROSE_GOLD_LEGGINGS)) {
                boolean boost = living.m_21055_((Item)MKBItems.ROSE_TEAR.get());
                MobEffectInstance instance = new MobEffectInstance((MobEffect)MKBEffects.EMBRACE_OF_ROSE.get(), 240, boost ? 1 : 0);
                attacker.m_7292_(instance);
            }
            if (EntityEvents.hasArmor(living, MKBItems.AURIFEROMETEORITE_CHESTPLATE)) {
                attacker.m_20254_(entity.m_20094_() / 20 + 4);
            }
            if (living.m_21023_((MobEffect)MKBEffects.ANCIENT_ABYSS_POWER.get())) {
                attacker.m_6469_(attacker.m_269291_().m_269425_(), 2.0f);
            }
            if (Math.random() > 0.6 && attacker.m_21023_((MobEffect)MKBEffects.SANGUINARY_THIRST.get())) {
                attacker.m_5634_(EntityEvents.hasArmor(attacker, MKBItems.BLOOD_BOOTS) ? 2.0f : 1.0f);
            }
            if (source.m_276093_(DamageTypes.f_268679_) && living instanceof Player && (player = (Player)living).m_21254_() && player.m_21211_().m_41720_() instanceof SoulShieldItem) {
                player.m_21211_().m_41622_((int)event.getAmount(), (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                SoulShieldItem.SonicBlock(player);
                event.setCanceled(true);
            }
        }
        if (living instanceof EnderDragon && entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getAmount() >= 12.0f && Math.random() > 0.2) {
                event.setAmount(event.getAmount() - 2.0f);
                Level level = player.m_9236_();
                ItemStack stack = new ItemStack((ItemLike)MKBItems.ENDER_SCALE.get(), Mth.m_14107_((double)(2.0 * Math.random())));
                double d1 = living.m_20185_() + 0.5 + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25);
                double d2 = living.m_20186_() + 0.5 + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25) - 3.0;
                double d3 = living.m_20189_() + 0.5 + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25);
                if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46136_) && !level.restoringBlockSnapshots) {
                    ItemEntity itemEntity = new ItemEntity(level, d1, d2, d3, stack);
                    itemEntity.m_32060_();
                    itemEntity.m_146915_(true);
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void entityKilled(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        Entity attacker = source.m_7640_();
        if (attacker instanceof Player) {
            MobEffectInstance effectInstance;
            Player player = (Player)attacker;
            ItemStack stack = player.m_21206_();
            if (stack.m_41720_() instanceof BloodVesselItem) {
                BloodVesselItem.setFilling(stack, BloodVesselItem.getFilling(stack) + (float)Math.random() + 0.1f);
                if (BloodVesselItem.getFilling(stack) > 20.0f) {
                    player.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)MKBItems.BLOOD_VESSEL_FILLED.get()));
                }
            }
            if ((effectInstance = player.m_21124_((MobEffect)MKBEffects.SANGUINARY_THIRST.get())) != null) {
                int duration = effectInstance.m_19557_();
                int amplifier = effectInstance.m_19564_();
                if (duration < 600) {
                    duration += 100;
                } else {
                    amplifier = Math.min(amplifier + 1, 4);
                    duration -= 200;
                }
                player.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.SANGUINARY_THIRST.get(), duration, amplifier));
            }
        }
    }

    @SubscribeEvent
    public static void shieldBlock(ShieldBlockEvent event) {
        LivingEntity blocker = event.getEntity();
        DamageSource source = event.getDamageSource();
        Entity directEntity = source.m_7640_();
        if (blocker.m_21211_().m_41720_() == MKBItems.SOUL_SHIELD.get()) {
            MobEffectInstance effectInstance = blocker.m_21124_((MobEffect)MKBEffects.POWER_OF_RESENTMENT.get());
            if (effectInstance != null) {
                int amp = Math.min(effectInstance.m_19564_() + 1, 4);
                blocker.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.POWER_OF_RESENTMENT.get(), 200, amp));
            } else {
                blocker.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.POWER_OF_RESENTMENT.get(), 200, 0));
            }
        } else if (blocker.m_21211_().m_41720_() == MKBItems.CORAL_SHIELD.get() && directEntity instanceof Projectile) {
            CoralArrow coralArrow = new CoralArrow(directEntity.m_9236_(), (Entity)blocker);
            Vec3 speed = directEntity.m_20184_().m_82490_((double)-1.2f);
            coralArrow.m_6686_(speed.f_82479_, speed.f_82480_, speed.f_82481_, (float)speed.m_82553_(), 0.0f);
            directEntity.m_9236_().m_7967_((Entity)coralArrow);
            for (int i = 0; i < 4 && Math.random() < 0.9 - 0.1 * (double)i; ++i) {
                coralArrow = new CoralArrow(directEntity.m_9236_(), (Entity)blocker);
                speed = directEntity.m_20184_().m_82490_((double)-1.2f);
                coralArrow.m_6686_(speed.f_82479_, speed.f_82480_, speed.f_82481_, (float)speed.m_82553_(), 20.0f);
                directEntity.m_9236_().m_7967_((Entity)coralArrow);
            }
        }
    }

    @SubscribeEvent
    public static void entityFall(LivingFallEvent event) {
        float distance = event.getDistance();
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof Player) {
            float jumpDistanse;
            Player player = (Player)entity;
            if (CompatHandler.twilightforest && distance > (jumpDistanse = player.m_285755_() + 2.6f) && player.m_21205_().m_41720_().equals(TFCompats.TFItems.CHERRY_FAN.get()) && !player.getCapability(CapabilityList.FEATHER_FAN_FALLING).map(FeatherFanFallCapability::getFalling).orElse(true).booleanValue()) {
                Vec3 vec3 = player.m_20184_();
                player.m_20334_(vec3.f_82479_, (double)0.6f, vec3.f_82481_);
                player.getCapability(CapabilityList.FEATHER_FAN_FALLING).ifPresent(cap -> cap.setFalling(true));
                player.m_5496_((SoundEvent)TFSounds.FAN_WHOOSH.get(), 1.0f + level.m_213780_().m_188501_(), level.m_213780_().m_188501_() * 0.7f + 0.3f);
                event.setCanceled(true);
            }
        }
    }
}

