/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.events;

import com.auviotre.makit_better.init.MKBEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("makit_better", "textures/gui/icons.png");
    private final Random random = new Random();
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;

    @SubscribeEvent
    public void onPreRenderHUD(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            MobEffectInstance effectInstance;
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            if (event.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && (effectInstance = player.m_21124_((MobEffect)MKBEffects.CURSE_OF_RESENTMENT.get())) != null) {
                if (effectInstance.m_19564_() < 5) {
                    this.CustomHealth(event, 0);
                } else {
                    this.CustomHealth(event, 18);
                }
            }
        }
    }

    private void CustomHealth(RenderGuiOverlayEvent.Pre event, int offset) {
        boolean highlight;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ForgeGui gui = (ForgeGui)mc.f_91065_;
        GuiGraphics graphics = event.getGuiGraphics();
        gui.setupOverlayRenderState(true, false);
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        event.setCanceled(true);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS);
        RenderSystem.enableBlend();
        int health = Mth.m_14167_((float)player.m_21223_());
        int tickCount = gui.m_93079_();
        boolean bl = highlight = this.healthBlinkTime > (long)tickCount && (this.healthBlinkTime - (long)tickCount) / 3L % 2L == 1L;
        if (health < this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = Util.m_137550_();
            this.healthBlinkTime = tickCount + 20;
        } else if (health > this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = Util.m_137550_();
            this.healthBlinkTime = tickCount + 10;
        }
        if (Util.m_137550_() - this.lastHealthTime > 1000L) {
            this.lastHealth = health;
            this.displayHealth = health;
            this.lastHealthTime = Util.m_137550_();
        }
        this.lastHealth = health;
        int healthLast = this.displayHealth;
        AttributeInstance maxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = 20.0f;
        if (maxHealth != null) {
            healthMax = (float)maxHealth.m_22135_();
        }
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.random.setSeed((long)tickCount * 312871L);
        int left = width / 2 - 91;
        int top = height - gui.leftHeight;
        gui.leftHeight += healthRows * rowHeight;
        if (rowHeight != 10) {
            gui.leftHeight += 10 - rowHeight;
        }
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = tickCount % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        int TOP = player.m_9236_().m_6106_().m_5466_() ? 9 : 0;
        int margin = 34 + offset;
        float absorbRemaining = absorb;
        for (int i = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health + absorb <= 4) {
                y += this.random.nextInt(2);
            }
            if (i == regen && (float)i < healthMax) {
                y -= 2;
            }
            graphics.m_280218_(ICONS, x, y, highlight ? 25 : 16, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    graphics.m_280218_(ICONS, x, y, margin, TOP + 18, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    graphics.m_280218_(ICONS, x, y, margin + 9, TOP + 18, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == (float)absorb && (float)absorb % 2.0f == 1.0f) {
                    graphics.m_280218_(ICONS, x, y, margin + 9, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                graphics.m_280218_(ICONS, x, y, margin, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                graphics.m_280218_(ICONS, x, y, margin, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            graphics.m_280218_(ICONS, x, y, margin + 9, TOP, 9, 9);
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS);
    }

    @SubscribeEvent
    public void MovementInput(MovementInputUpdateEvent event) {
    }
}

