/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.events;

import com.auviotre.makit_better.entities.HeartOfTitanium;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BossBarEvent {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("makit_better", "textures/gui/boss_bar_frames.png");
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    public static final Set<Mob> BOSSES = Sets.newHashSet();

    @SubscribeEvent
    public static void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!BOSSES.isEmpty()) {
            int displayWidth = minecraft.m_91268_().m_85445_();
            for (Mob boss : BOSSES) {
                if (boss == null || event.getBossEvent().m_18860_() != boss.m_20148_()) continue;
                event.setCanceled(true);
                int startX = displayWidth / 2 - 94;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BossBarEvent.drawBar(event.getGuiGraphics(), startX, event.getY() - 2, boss, (BossEvent)event.getBossEvent());
                Component text = boss.m_5446_();
                event.getGuiGraphics().m_280653_(minecraft.f_91062_, text, displayWidth / 2, event.getY() - 11, 0xFFFFFF);
                if (event.getY() >= minecraft.m_91268_().m_85446_() / 3) break;
                Objects.requireNonNull(minecraft.f_91062_);
                event.setIncrement(21);
            }
        }
    }

    private static void drawBar(GuiGraphics poseStack, int pX, int pY, Mob entity, BossEvent bossEvent) {
        int i = (int)(bossEvent.m_142717_() * 182.0f);
        if (entity instanceof HeartOfTitanium) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            poseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 10.0f, 182, 5, 256, 256);
            if (i > 0) {
                poseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 15.0f, i, 5, 256, 256);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            poseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 0.0f, 188, 9, 256, 256);
        }
    }

    public static void addBoss(Mob mob) {
        BOSSES.add(mob);
    }

    public static void removeBoss(Mob mob) {
        BOSSES.remove(mob);
    }

    public static Set<Mob> getBosses() {
        return BOSSES;
    }
}

