/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities.projectile;

import com.auviotre.makit_better.entities.projectile.WaterTrident;
import com.auviotre.makit_better.init.MKBEntityTypes;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.init.MKBParticleTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownTitandent
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownTitandent.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownTitandent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack titandentItem = new ItemStack((ItemLike)MKBItems.TITANDENT.get());
    private boolean dealtDamage;
    private int timer = 0;
    private Vec3 tempPos;
    private Vec3 tempMovement;
    public int clientSideReturnTridentTickCount;

    public ThrownTitandent(EntityType<? extends ThrownTitandent> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownTitandent(Level level, LivingEntity livingentity, ItemStack itemStack) {
        super((EntityType)MKBEntityTypes.THROWN_TITANDENT.get(), livingentity, level);
        this.titandentItem = itemStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.isMultishot() && !this.dealtDamage && this.timer < 3) {
            ++this.timer;
            if (this.timer == 1) {
                this.tempMovement = this.m_20184_();
                this.tempPos = this.m_20318_(0.0f);
            }
            if (this.timer == 2) {
                for (int i = 0; i < 9; ++i) {
                    WaterTrident waterTrident = new WaterTrident(this.m_9236_(), (LivingEntity)this.m_19749_());
                    double theta = Math.random() * 2.0 * Math.PI;
                    double phi = (Math.random() - 0.5) * Math.PI;
                    double deltaX = Math.sin(theta) * Math.cos(phi);
                    double deltaY = Math.sin(phi);
                    double deltaZ = Math.cos(theta) * Math.cos(phi);
                    double length = 0.2;
                    waterTrident.m_20219_(this.tempPos.m_82549_(new Vec3(length * deltaX, length * deltaY, length * deltaZ)));
                    waterTrident.m_246865_(this.tempMovement.m_82490_(0.64));
                    length = this.tempMovement.m_82490_(0.2).m_82554_(Vec3.f_82478_);
                    waterTrident.m_246865_(new Vec3(length * deltaX, length * deltaY, length * deltaZ));
                    waterTrident.m_5602_(this.m_19749_());
                    this.m_9236_().m_7967_((Entity)waterTrident);
                }
            }
        }
        double posX = this.m_20185_() + 0.1 * (Math.random() - 0.5);
        double posY = this.m_20186_() + 0.1 * (Math.random() - 0.5);
        double posZ = this.m_20189_() + 0.1 * (Math.random() - 0.5);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, posX, posY, posZ, 0.0, Math.random(), 0.0);
        this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), posX, posY, posZ, 0.0, Math.random(), 0.0);
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.titandentItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        float f = 11.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.titandentItem, (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        boolean flag = entity.m_6469_(damagesource, f);
        if (flag && entity.m_6095_() == EntityType.f_20566_) {
            return;
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.m_9236_() instanceof ServerLevel && this.m_9236_().m_46470_() && this.isChanneling()) {
            LightningBolt lightningbolt;
            BlockPos blockpos = entity.m_20183_();
            if (this.m_9236_().m_45527_(blockpos) && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                ServerPlayer lightningOwner = entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null;
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                lightningbolt.m_20879_(lightningOwner);
                this.m_9236_().m_7967_((Entity)lightningbolt);
                soundevent = SoundEvents.f_12521_;
                f1 = 5.0f;
                if (this.isMultishot()) {
                    List entities = this.m_9236_().m_45933_(entity, this.m_20191_().m_82377_(4.0, 4.0, 4.0));
                    entities.remove(entity);
                    LightningBolt lightningboltBonus = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    assert (lightningboltBonus != null);
                    for (int i = 0; i < 2 && !entities.isEmpty(); ++i) {
                        lightningboltBonus.m_20879_(lightningOwner);
                        int index = (int)(Math.random() * (double)entities.size());
                        Entity next = (Entity)entities.get(index);
                        lightningboltBonus.m_20219_(Vec3.m_82539_((Vec3i)next.m_20183_()));
                        entities.remove(index);
                        this.m_9236_().m_7967_((Entity)lightningboltBonus);
                    }
                }
            }
        }
        if (flag && entity instanceof LivingEntity) {
            LivingEntity livingEntity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingEntity1, (Entity)entity1);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingEntity1);
            }
            this.m_7761_(livingEntity1);
        }
        this.m_5496_(soundevent, f1, 1.6f);
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.titandentItem);
    }

    public boolean isMultishot() {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44959_, (ItemStack)this.titandentItem) > 0;
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Titandent", 10)) {
            this.titandentItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Titandent"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.titandentItem)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Titandent", (Tag)this.titandentItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 1.08f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }
}

