/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities.projectile;

import com.auviotre.makit_better.init.MKBEntityTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MeteoriteRock
extends AbstractArrow {
    public MeteoriteRock(EntityType<? extends MeteoriteRock> entityType, Level level) {
        super(entityType, level);
    }

    public MeteoriteRock(Level level, LivingEntity entity, Vec3 pos) {
        super((EntityType)MKBEntityTypes.METEORITE_ROCK.get(), level);
        this.m_5602_((Entity)entity);
        this.m_6034_(pos.f_82479_, pos.f_82480_ + 36.0, pos.f_82481_);
        this.m_20334_(0.0, -2.0, 0.0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20254_(1);
        for (int i = 0; i < 3; ++i) {
            double px = this.m_20185_() + Math.random() * 0.2;
            double py = this.m_20186_() + this.m_20184_().f_82480_ * (double)i / 3.0;
            double pz = this.m_20189_() + Math.random() * 0.2;
            double dx = px - this.m_20185_();
            double dz = pz - this.m_20189_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, px, py, pz, dx * 2.0, this.m_20184_().f_82480_ * 0.1, dz * 2.0);
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(0.5));
        this.explosion();
    }

    protected void m_8060_(BlockHitResult result) {
        BlockState blockstate = this.m_9236_().m_8055_(result.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, result, (Projectile)this);
        this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(0.5));
        this.explosion();
    }

    public void m_7822_(byte event) {
        if (event == 3) {
            int i;
            for (i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + Math.random() * 2.0 - 1.0, this.m_20186_() + 0.5, this.m_20189_() + Math.random() * 2.0 - 1.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 9; ++i) {
                double px = this.m_20185_() + Math.random() * 0.2;
                double py = this.m_20186_();
                double pz = this.m_20189_() + Math.random() * 0.2;
                double dx = px - this.m_20185_();
                double dz = pz - this.m_20189_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, px, py, pz, dx * 5.0, Math.random() * 0.1, dz * 5.0);
            }
        }
    }

    private void explosion() {
        this.m_9236_().m_7605_((Entity)this, (byte)3);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
        int radius = 5;
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_((double)radius, (double)radius, (double)radius));
        for (Entity entity : entities) {
            if (entity.m_20147_() || entity == this.m_19749_()) continue;
            double distance = Math.sqrt(Math.pow(entity.m_20185_() - this.m_20185_(), 2.0) + Math.pow(entity.m_20186_() - this.m_20186_(), 2.0) + Math.pow(entity.m_20189_() - this.m_20189_(), 2.0));
            distance = Math.max(distance, 1.0);
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(entity.m_269291_().m_269333_((LivingEntity)this.m_19749_()), (float)(16.0 / distance));
            entity.m_20254_(6);
            entity.m_246865_(entity.m_20184_().m_82520_((entity.m_20185_() - this.m_20185_()) * 0.25 / distance / distance, 0.03 / distance, (entity.m_20189_() - this.m_20189_()) * 0.25 / distance / distance));
        }
        this.m_146870_();
    }

    protected ItemStack m_7941_() {
        return null;
    }
}

