/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities.projectile;

import com.auviotre.makit_better.init.MKBBlocks;
import com.auviotre.makit_better.init.MKBEntityTypes;
import com.auviotre.makit_better.init.MKBItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class CoralStar
extends ThrowableItemProjectile {
    public CoralStar(EntityType<? extends CoralStar> entityType, Level level) {
        super(entityType, level);
    }

    public CoralStar(Level level, LivingEntity livingEntity) {
        super((EntityType)MKBEntityTypes.CORAL_STAR.get(), livingEntity, level);
    }

    public CoralStar(Level level, double vx, double vy, double vz) {
        super((EntityType)MKBEntityTypes.CORAL_STAR.get(), vx, vy, vz, level);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.popSelf();
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos blockPos = result.m_82425_().m_7494_();
        Level level = this.m_9236_();
        BlockState state = level.m_8055_(blockPos);
        FluidState fluidState = level.m_6425_(blockPos);
        if (this.waterDetect(level, blockPos) && this.waterDetect(level, blockPos.m_7494_()) && level.m_8055_(blockPos.m_7495_()).m_60815_()) {
            this.placeMush(level, blockPos);
        } else {
            this.popSelf();
        }
    }

    private boolean waterDetect(Level level, BlockPos blockPos) {
        BlockState state = level.m_8055_(blockPos);
        FluidState fluidState = level.m_6425_(blockPos);
        return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && state.m_60734_() == Blocks.f_49990_;
    }

    private void placeMush(Level level, BlockPos blockPos) {
        level.m_46597_(blockPos, (BlockState)((Block)MKBBlocks.CORAL_MUSH_BLOCK.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
        this.m_9236_().m_7605_((Entity)this, (byte)7);
        level.m_5594_(null, blockPos, SoundEvents.f_11828_, SoundSource.BLOCKS, 1.2f, 0.8f);
    }

    private void popSelf() {
        Entity owner = this.m_19749_();
        if (owner != null && owner instanceof Player) {
            Player player = (Player)owner;
            if (!player.m_150110_().f_35937_) {
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)MKBItems.CORAL_STAR.get()));
                itemEntity.m_32060_();
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
    }

    protected Item m_7881_() {
        return (Item)MKBItems.CORAL_STAR.get();
    }

    public static ParticleOptions getParticle() {
        ItemStack itemstack = new ItemStack((ItemLike)MKBBlocks.CORAL_MUSH_BLOCK.get());
        return new ItemParticleOption(ParticleTypes.f_123752_, itemstack);
    }

    public void m_7822_(byte event) {
        if (event == 3) {
            ParticleOptions particleoptions = CoralStar.getParticle();
            for (int i = 0; i < 8; ++i) {
                double theta = Math.random() * 2.0 * Math.PI;
                double phi = (Math.random() - 0.5) * Math.PI;
                double deltaX = 0.2 * Math.sin(theta) * Math.cos(phi);
                double deltaY = 0.2 * Math.sin(phi) + 0.05;
                double deltaZ = 0.2 * Math.cos(theta) * Math.cos(phi);
                this.m_9236_().m_7106_(particleoptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), deltaX, deltaY, deltaZ);
            }
        } else if (event == 7) {
            BlockPos blockPos = this.m_20183_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)blockPos.m_123341_() + 0.1, (double)blockPos.m_123342_() + 1.1, (double)blockPos.m_123343_() + 0.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)blockPos.m_123341_() + 0.9, (double)blockPos.m_123342_() + 1.1, (double)blockPos.m_123343_() + 0.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)blockPos.m_123341_() + 0.1, (double)blockPos.m_123342_() + 1.1, (double)blockPos.m_123343_() + 0.9, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)blockPos.m_123341_() + 0.9, (double)blockPos.m_123342_() + 1.1, (double)blockPos.m_123343_() + 0.9, 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82490_(1.12));
        }
        double posX = this.m_20185_() + 0.1 * (Math.random() - 0.5);
        double posY = this.m_20186_() + 0.1 * (Math.random() - 0.5);
        double posZ = this.m_20189_() + 0.1 * (Math.random() - 0.5);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, posX, posY, posZ, 0.0, Math.random(), 0.0);
    }
}

