/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities.animated;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AnimatedEntity
extends Monster
implements IAnimatedEntity {
    private int animationTick;
    private Animation currentAnimation;

    protected AnimatedEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (animation != NO_ANIMATION) {
            this.onAnimationStart(animation);
        } else {
            this.onAnimationFinish(this.currentAnimation);
        }
        this.currentAnimation = animation;
        this.setAnimationTick(0);
    }

    protected void onAnimationStart(Animation animation) {
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION};
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
        livingEntity.m_5810_();
        livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
    }

    public List<LivingEntity> getNearByLivingEntities(double range) {
        return this.getNearByEntities(LivingEntity.class, range, range, range, range);
    }

    public List<LivingEntity> getNearByLivingEntities(double rangeX, double height, double rangeZ, double radius) {
        return this.getNearByEntities(LivingEntity.class, rangeX, height, rangeZ, radius);
    }

    public <T extends Entity> List<T> getNearByEntities(Class<T> entityClass, double x, double y, double z, double radius) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(x, y, z), targetEntity -> targetEntity != this && (double)this.m_20270_((Entity)targetEntity) <= radius + (double)(targetEntity.m_20205_() / 2.0f) && targetEntity.m_20186_() <= this.m_20186_() + y);
    }

    public static double getAngleBetweenEntities(Entity attacker, Entity target) {
        return Math.atan2(target.m_20189_() - attacker.m_20189_(), target.m_20185_() - attacker.m_20185_()) * 57.29577951308232 + 90.0;
    }

    protected void pushEntitiesAway(float X, float Y, float Z, float radius) {
        List<LivingEntity> entityList = this.getNearByLivingEntities(X, Y, Z, radius);
        for (Entity entity : entityList) {
            if (entity.f_19794_ || !entity.m_6087_()) continue;
            double angle = (AnimatedEntity.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.m_20334_(-0.1 * Math.cos(angle), entity.m_20184_().f_82480_, -0.1 * Math.sin(angle));
        }
    }

    public Vec3 circlePosition(Vec3 targetVec3, float radius, float speed, boolean direction, int circleFrame, float offset) {
        double theta = (double)((direction ? 1 : -1) * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return targetVec3.m_82520_((double)radius * Math.cos(theta), 0.0, (double)radius * Math.sin(theta));
    }
}

