/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities;

import com.auviotre.makit_better.entities.projectile.SweetBullet;
import com.auviotre.makit_better.init.MKBEntityTypes;
import com.auviotre.makit_better.init.MKBItems;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SugarElf
extends TamableAnimal {
    private final SimpleContainer inventory = new SimpleContainer(1);
    private int sugarGetTick = 0;
    private float holdingItemAnimationTicks;
    private float holdingItemAnimationTicks0;

    public SugarElf(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21553_(false);
    }

    public SugarElf(Level level, double x, double y, double z) {
        this((EntityType<? extends TamableAnimal>)((EntityType)MKBEntityTypes.SUGAR_ELF.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public static AttributeSupplier.Builder registerEntityAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22280_, (double)0.2f).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new HealOwnerGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal(this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), false));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected SoundEvent m_7515_() {
        return this.m_21033_(EquipmentSlot.MAINHAND) ? SoundEvents.f_215670_ : SoundEvents.f_215671_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_215675_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215672_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && !this.m_9236_().f_46443_ && this.f_19797_ % 100 == 0) {
            this.m_5634_(1.0f);
        }
        if (this.m_6084_() && this.m_21205_().m_41720_().equals(Items.f_42501_) && this.sugarGetTick + 50 <= this.f_19797_) {
            this.m_5634_(8.0f);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.spawnHeartParticle();
            this.sugarGetTick = 0;
            this.m_9236_().m_245747_(this.m_20183_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 0.6f, 1.25f, true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_269323_() != null && this.m_20188_() < this.m_269323_().m_20188_() + 3.0 && this.m_20270_((Entity)this.m_269323_()) < 6.4f && this.f_19796_.m_188503_(12) == 0) {
            this.m_246865_(new Vec3(0.0, 0.02, 0.0));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            this.holdingItemAnimationTicks0 = this.holdingItemAnimationTicks;
            this.holdingItemAnimationTicks = this.hasItemInHand() ? Mth.m_14036_((float)(this.holdingItemAnimationTicks + 1.0f), (float)0.0f, (float)5.0f) : Mth.m_14036_((float)(this.holdingItemAnimationTicks - 1.0f), (float)0.0f, (float)5.0f);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack selfStack = this.m_21120_(InteractionHand.MAIN_HAND);
        if (selfStack.m_41619_() && !stack.m_41619_()) {
            if (stack.m_41720_().equals(Items.f_42501_)) {
                ItemStack copyStack = stack.m_255036_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, copyStack);
                this.removeInteractionItem(player, stack);
                this.m_9236_().m_6269_(player, (Entity)this, SoundEvents.f_215676_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                if (this.m_269323_() == null || Math.random() > 0.6 && this.m_269323_() != player) {
                    this.m_21816_(player.m_20148_());
                }
                this.sugarGetTick = this.f_19797_;
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_().equals(MKBItems.SUGAR_STEEL_INGOT.get())) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.removeInteractionItem(player, stack);
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)MKBItems.SUGAR_TOTEM.get()));
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        return super.m_6071_(player, hand);
    }

    public boolean hasItemInHand() {
        return !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public float getHoldingItemAnimationProgress(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.holdingItemAnimationTicks0, (float)this.holdingItemAnimationTicks) / 5.0f;
    }

    private void removeInteractionItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean m_7243_(ItemStack pStack) {
        return false;
    }

    public boolean m_142039_() {
        return !this.m_20096_();
    }

    protected boolean m_213814_() {
        return false;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, (double)this.m_20205_() * 0.1);
    }

    public double m_6049_() {
        return 0.4;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.6f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        return spawnGroupData;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private void spawnHeartParticle() {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    static class HealOwnerGoal
    extends Goal {
        private final SugarElf elf;
        private LivingEntity owner;
        private final double speedModifier;
        private int cooldown = 0;
        private final PathNavigation navigation;
        private int timeToRecalcPath;

        public HealOwnerGoal(SugarElf elf, double modifier) {
            this.elf = elf;
            this.speedModifier = modifier;
            this.navigation = elf.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.elf.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            this.owner = livingentity;
            if (this.elf.m_20280_((Entity)this.owner) > 80.0) {
                return false;
            }
            if (this.elf.hasItemInHand()) {
                if (this.elf.m_21205_().m_41720_().equals(MKBItems.SUGAR_CORE.get())) {
                    return (double)this.owner.m_21223_() <= (double)this.owner.m_21233_() * 0.8;
                }
                return false;
            }
            return (double)this.owner.m_21223_() <= (double)this.owner.m_21233_() * 0.8;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        private Vec3 getPosition() {
            BlockPos blockpos = this.owner.m_20183_().m_6630_(5);
            return blockpos.m_252807_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.cooldown = 20;
            this.timeToRecalcPath = 0;
            this.elf.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)MKBItems.SUGAR_CORE.get()));
        }

        public void m_8041_() {
            this.navigation.m_26573_();
            this.elf.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }

        public void m_8037_() {
            boolean flag = this.elf.m_21574_().m_148306_((Entity)this.owner);
            if (flag) {
                this.elf.m_21391_((Entity)this.owner, 30.0f, 30.0f);
                --this.cooldown;
                if (this.cooldown <= 0) {
                    this.cooldown = 100;
                    SweetBullet bullet = new SweetBullet(this.elf.m_9236_(), (LivingEntity)this.elf, 4.0f);
                    bullet.m_37251_((Entity)this.elf, this.getRot((LivingEntity)this.owner).f_82470_, this.getRot((LivingEntity)this.owner).f_82471_, 0.0f, 2.0f, 0.0f);
                    this.elf.m_9236_().m_7967_((Entity)bullet);
                }
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_26519_(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, this.speedModifier);
            }
        }

        private Vec2 getRot(LivingEntity entity) {
            double d0 = entity.m_20185_() - this.elf.m_20185_();
            double d2 = entity.m_20189_() - this.elf.m_20189_();
            double d1 = entity.m_20188_() - this.elf.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            return new Vec2(f1, f);
        }
    }

    static class FollowOwnerGoal
    extends Goal {
        private final SugarElf elf;
        private LivingEntity owner;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;

        public FollowOwnerGoal(SugarElf elf, double modifier) {
            this.elf = elf;
            this.speedModifier = modifier;
            this.navigation = elf.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.elf.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (this.elf.m_20280_((Entity)livingentity) < 100.0) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(this.elf.m_20280_((Entity)this.owner) <= 16.0);
        }

        private boolean unableToMove() {
            return this.elf.m_20159_() || this.elf.m_21523_();
        }

        private Vec3 getPosition() {
            BlockPos blockpos = this.owner.m_20183_().m_6630_(3);
            return blockpos.m_252807_();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.navigation.m_26573_();
        }

        public void m_8037_() {
            this.elf.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.elf.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_26519_(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, this.speedModifier * this.speedModify());
            }
        }

        private double speedModify() {
            if (this.owner != null && this.elf.m_20280_((Entity)this.owner) >= 40.0) {
                return 1.25;
            }
            return 1.0;
        }
    }
}

