/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.entities;

import com.auviotre.makit_better.entities.ai.AnimationGoal;
import com.auviotre.makit_better.entities.ai.AttackMoveGoal;
import com.auviotre.makit_better.entities.animated.AnimatedEntity;
import com.auviotre.makit_better.entities.etc.MKBServerBossEvent;
import com.auviotre.makit_better.entities.projectile.WaterTrident;
import com.auviotre.makit_better.init.MKBEffects;
import com.auviotre.makit_better.init.MKBEntityTypes;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.init.MKBParticleTypes;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class HeartOfTitanium
extends AnimatedEntity
implements RangedAttackMob {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private final List<Entity> ignoreEntities = new ArrayList<Entity>();
    private static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.8f)).build();
    private final MKBServerBossEvent bossEvent = new MKBServerBossEvent(this.m_20148_(), (Mob)this, BossEvent.BossBarColor.BLUE, true);
    public static final Animation SWEEP_ATTACK = Animation.create((int)30);
    public static final Animation RIPTIDE = Animation.create((int)21);
    public static final Animation RIPTIDE_ATTACK = Animation.create((int)38);
    public static final Animation TRIDENT_SPAWN = Animation.create((int)26);
    public static final Animation TRACE = Animation.create((int)100);
    public static final Animation TRANSFORM = Animation.create((int)24);
    private int tridentTimer = 0;
    private int riptideTimer = 0;
    private Vec3 randomPos = Vec3.f_82478_;
    private boolean activated = false;
    private static final EntityDataAccessor<Boolean> DATA_ACTIVATED = SynchedEntityData.m_135353_(HeartOfTitanium.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float minHealth = this.m_21233_();

    public HeartOfTitanium(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 36;
        this.f_21342_ = new WaterMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public HeartOfTitanium(Level level) {
        this((EntityType<? extends Monster>)((EntityType)MKBEntityTypes.HEART_OF_TITANIUM.get()), level);
    }

    public static AttributeSupplier.Builder registerEntityAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.144).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 0.1).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 15.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVATED, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SweepAttack(this, SWEEP_ATTACK, true, 0.8f));
        this.f_21345_.m_25352_(1, (Goal)new SweepAttack(this, RIPTIDE_ATTACK, false, 0.85f));
        this.f_21345_.m_25352_(2, (Goal)new SweepAttack(this, TRACE, false, 0.2f));
        this.f_21345_.m_25352_(2, (Goal)new TitandentAttackGoal(this, TRIDENT_SPAWN));
        this.f_21345_.m_25352_(3, new AttackMoveGoal<HeartOfTitanium>(this, true, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HeartOfTitanium.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, false));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return POSES.getOrDefault(pose, STANDING_DIMENSIONS);
    }

    public float m_20236_(Pose pose) {
        if (pose == Pose.SWIMMING) {
            return 0.45f;
        }
        return 1.6f;
    }

    protected void m_7472_(DamageSource damageSource, int p_31465_, boolean p_31466_) {
        super.m_7472_(damageSource, p_31465_, p_31466_);
        ItemEntity itementity = this.m_20000_((ItemLike)MKBItems.ACTIVATED_BIO_TITANIUM.get(), this.f_19796_.m_188503_(2) + 1);
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 4 == 0) {
            this.bossEvent.update();
        }
        if (this.getAnimation() == SWEEP_ATTACK) {
            if (this.getAnimationTick() == 12) {
                this.m_5496_(SoundEvents.f_12520_, 1.2f, 0.6f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                this.sweep(2.5f, 3.0f, 80.0f, 0.9f, 0.0f, 0, 0.0f);
                this.bubbleSweep(1.25, 5, 45.0, 15.0);
            }
            if (this.getAnimationTick() == 13) {
                this.bubbleSweep(1.25, 6, 15.0, -15.0);
            }
            if (this.getAnimationTick() == 14) {
                this.bubbleSweep(1.25, 5, -15.0, -45.0);
            }
            if (this.getAnimationTick() == 22) {
                this.m_5496_(SoundEvents.f_12520_, 1.3f, 1.0f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                this.sweep(3.0f, 3.5f, 108.0f, 0.9f, 0.04f, 12 + this.f_19796_.m_188503_(8), 0.2f);
                this.bubbleSweep(1.6, 6, -55.0, -15.0);
            }
            if (this.getAnimationTick() == 23) {
                this.bubbleSweep(1.6, 8, 15.0, -15.0);
            }
            if (this.getAnimationTick() == 24) {
                this.bubbleSweep(1.6, 6, 15.0, 50.0);
            }
        }
        if (this.getAnimation() == RIPTIDE_ATTACK) {
            if (this.getAnimationTick() == 10) {
                this.m_5496_(SoundEvents.f_12520_, 1.2f, 0.7f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                this.sweep(2.8f, 3.2f, 90.0f, 1.0f, 0.04f, 5, 0.05f);
                this.bubbleSweep(1.3, 5, 50.0, 15.0);
            }
            if (this.getAnimationTick() == 11) {
                this.bubbleSweep(1.3, 6, 15.0, -15.0);
            }
            if (this.getAnimationTick() == 12) {
                this.bubbleSweep(1.3, 5, -15.0, -50.0);
            }
            if (this.getAnimationTick() == 19) {
                this.m_5496_(SoundEvents.f_12520_, 1.3f, 1.1f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                this.sweep(3.2f, 3.6f, 125.0f, 1.1f, 0.08f, 20 + this.f_19796_.m_188503_(10), 0.25f);
                this.bubbleSweep(1.65, 6, -60.0, -15.0);
            }
            if (this.getAnimationTick() == 20) {
                this.bubbleSweep(1.65, 8, 15.0, -15.0);
            }
            if (this.getAnimationTick() == 21) {
                this.bubbleSweep(1.65, 6, 15.0, 55.0);
            }
            if (this.getAnimationTick() == 29) {
                this.m_5496_(SoundEvents.f_12518_, 1.25f, 1.1f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                this.m_246865_(this.m_20252_(0.0f).m_82490_(this.activated ? (double)3.2f : 2.75));
                if (this.m_5448_() != null) {
                    this.m_246865_(new Vec3(0.0, this.m_5448_().m_20186_() - this.m_20186_(), 0.0).m_82541_().m_82490_(this.activated ? (double)1.4f : 1.0));
                }
                this.m_5634_(2.5f);
                this.m_246865_(new Vec3(0.0, 0.1, 0.0));
                this.f_20938_ = 16;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 16, 4, false, false));
                if (!this.m_9236_().f_46443_) {
                    this.m_21155_(4, true);
                }
            }
            if (this.getAnimationTick() >= 29) {
                this.riptide();
            }
            if (this.getAnimationTick() == 36) {
                this.ignoreEntities.clear();
            }
        }
        LivingEntity target = this.m_5448_();
        if (this.getAnimation() == RIPTIDE) {
            if (this.getAnimationTick() == 10) {
                this.m_5496_(SoundEvents.f_12519_, 1.25f, 1.1f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                if (target != null) {
                    this.m_246865_(target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(this.activated ? 2.75 : (double)2.4f));
                    this.m_246865_(new Vec3(0.0, target.m_20186_() - this.m_20186_(), 0.0).m_82541_().m_82490_(this.activated ? 1.5 : 1.0));
                } else {
                    this.m_246865_(this.m_20252_(0.0f).m_82490_(this.activated ? 3.0 : 2.5));
                }
                this.m_246865_(new Vec3(0.0, 0.1, 0.0));
                this.m_5634_(1.5f);
                this.f_20938_ = 12;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 13, 4, false, false));
                if (!this.m_9236_().f_46443_) {
                    this.m_21155_(4, true);
                }
                this.riptideTimer = 120;
                Drowned drowned = new Drowned(EntityType.f_20562_, this.m_9236_());
                drowned.m_146884_(this.m_20182_().m_82546_(this.m_20184_().m_82490_(0.5)));
                if (!this.m_9236_().m_8055_(drowned.m_20183_()).m_60815_()) {
                    drowned.m_21561_(true);
                    drowned.m_6710_(this.m_5448_());
                    drowned.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.TIATANIZING.get(), 600, 1));
                    drowned.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
                    drowned.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, drowned.m_20185_(), drowned.m_20186_(), drowned.m_20189_(), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7967_((Entity)drowned);
                }
            }
            if (this.getAnimationTick() >= 10) {
                this.riptide();
            }
            if (this.getAnimationTick() == 20) {
                this.ignoreEntities.clear();
            }
        }
        if (this.getAnimation() == TRIDENT_SPAWN) {
            if (this.getAnimationTick() == 18 && target != null) {
                this.m_6504_(target, 1.0f);
            }
            if (this.getAnimationTick() >= 6 && this.getAnimationTick() <= 20) {
                double percent = (double)(this.getAnimationTick() - 6) / 20.0;
                this.bubblePattern(2.1f, 0.64f, percent, this.m_20299_(0.6f));
                this.bubblePattern(1.8f, 0.4f, percent, this.m_20299_(0.6f));
            }
        }
        if (this.getAnimation() == TRACE) {
            if (this.getAnimationTick() >= 6 && this.getAnimationTick() <= 95) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2, 3, false, false));
                double percent = (double)(this.getAnimationTick() - 6) / 36.0;
                this.bubbleRing(2.1, 0.2, percent);
                this.bubbleRing(1.8, 0.5, percent);
                this.bubbleRing(1.0, 0.8, percent);
                if (target != null && (this.getAnimationTick() - 6) % (this.activated ? 6 : 8) == 0) {
                    this.performingDirectAttack(target);
                    if (target instanceof Player && (double)this.m_20270_((Entity)target) <= 4.0 && target.m_21254_()) {
                        HeartOfTitanium.disableShield(target, 20);
                    }
                    this.randomPosBuild();
                }
            }
            if (this.getAnimationTick() == 97) {
                this.tridentTimer = 400;
            }
        }
        if (this.getAnimation() == TRANSFORM) {
            this.setActivated(true);
            if (this.getAnimationTick() == 13) {
                this.transform();
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean m_5825_() {
        return this.activated;
    }

    public void m_8107_() {
        super.m_8107_();
        this.activated = this.getActivated();
        if (this.activated) {
            this.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.TIATANIZING.get(), 20, 0, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 0, false, false));
        }
        LivingEntity target = this.m_5448_();
        if (this.m_6084_() && !this.m_9236_().f_46443_) {
            --this.tridentTimer;
            --this.riptideTimer;
            if (this.m_21223_() < this.minHealth) {
                this.minHealth = this.m_21223_();
            }
            if (this.f_19797_ % 8 == 0) {
                List<LivingEntity> entitiesHit = this.getNearByLivingEntities(3.0, 3.0, 3.0, 3.0);
                for (LivingEntity entity : entitiesHit) {
                    if (!(entity instanceof Drowned)) continue;
                    Drowned drowned = (Drowned)entity;
                    drowned.m_6710_(this.m_5448_());
                }
            }
            if (target != null && target.m_6084_()) {
                if (this.getAnimation() == NO_ANIMATION && Math.random() > (double)(this.minHealth / this.m_21233_()) * 0.3 + 0.8 && this.m_20270_((Entity)target) > 1.5f && this.tridentTimer <= 0) {
                    this.randomPosBuild();
                    this.setAnimation(TRACE);
                    this.m_20124_(Pose.STANDING);
                    this.m_20282_(false);
                }
                if (this.getAnimation() == NO_ANIMATION && this.m_20182_().m_82546_(target.m_20182_().m_82549_(this.m_20184_())).m_82553_() <= (double)3.2f && this.f_19796_.m_188503_(this.activated ? 5 : 6) == 0) {
                    if (Math.random() > (double)(this.minHealth / this.m_21233_()) * 0.75 + 0.1) {
                        this.setAnimation(RIPTIDE_ATTACK);
                    } else {
                        this.setAnimation(SWEEP_ATTACK);
                    }
                    this.m_20124_(Pose.STANDING);
                    this.m_20282_(false);
                } else if (this.getAnimation() == NO_ANIMATION && Math.abs(this.m_20188_() - target.m_20227_(0.5)) < 6.0 && this.m_20270_((Entity)target) > 2.5f && this.m_20270_((Entity)target) < 24.0f && this.f_19796_.m_188503_(this.activated ? 6 : 10) == 0) {
                    if (this.riptideTimer <= 0 && Math.random() + (double)(this.m_20270_((Entity)target) / 24.0f) > (double)(this.minHealth / this.m_21233_()) * 0.4 + 0.75 && this.m_20270_((Entity)target) >= 3.0f) {
                        this.setAnimation(RIPTIDE);
                    } else {
                        this.setAnimation(TRIDENT_SPAWN);
                    }
                    this.m_20124_(Pose.STANDING);
                    this.m_20282_(false);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && (double)this.minHealth < 0.48 * (double)this.m_21233_() && !this.activated) {
                this.setAnimation(TRANSFORM);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 25, 5, false, false));
                this.m_20124_(Pose.STANDING);
                this.m_20282_(false);
            }
            if (!this.m_20069_() || target != null && !target.m_20069_()) {
                this.m_7292_(new MobEffectInstance((MobEffect)MKBEffects.TIATANIZING.get(), 160, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 160, 1));
            }
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_5842_() && this.getAnimation() == NO_ANIMATION) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
            double length = Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
            if (this.m_6069_() && length > (double)0.08f) {
                this.m_20124_(Pose.SWIMMING);
            } else {
                this.m_20124_(Pose.STANDING);
            }
        }
    }

    private void transform() {
        List<LivingEntity> entitiesHit = this.getNearByLivingEntities(50.0, 50.0, 50.0, 50.0);
        this.m_5496_(SoundEvents.f_12521_, 5.0f, 1.6f);
        for (LivingEntity target : entitiesHit) {
            if (target.m_20147_()) continue;
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            if (lightningbolt != null) {
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)target.m_20183_()));
                this.m_9236_().m_7967_((Entity)lightningbolt);
            }
            if (target instanceof Drowned) {
                Drowned drowned = (Drowned)target;
                drowned.m_146870_();
                this.m_5634_(6.0f);
            }
            if (target.m_20096_()) {
                target.m_20256_(target.m_20184_().m_82520_(0.0, 1.0, 0.0));
            } else {
                target.m_20256_(target.m_20184_().m_82520_(0.0, 0.8, 0.0));
            }
            if (!(target instanceof Player) || !target.m_21254_()) continue;
            HeartOfTitanium.disableShield(target, 100);
        }
        for (int i = 0; i < 256; ++i) {
            double theta = Math.random() * 2.0 * Math.PI;
            double phi = (Math.random() - 0.5) * Math.PI;
            double dx = Math.cos(theta) * Math.cos(phi);
            double dy = Math.sin(phi);
            double dz = Math.sin(theta) * Math.cos(phi);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20227_(0.8f), this.m_20189_(), dx, dy, dz);
        }
    }

    private void sweep(float range, float height, float arc, float damage, float healthPercentDamage, int shieldBreakTicks, float airborne) {
        if (this.activated) {
            range += 1.2f;
            height += 0.5f;
            damage *= 1.2f;
            healthPercentDamage *= 1.6f;
            shieldBreakTicks = (int)((double)shieldBreakTicks * 1.5);
            arc *= 1.1f;
        }
        List<LivingEntity> entitiesHit = this.getNearByLivingEntities(range, height, range, range);
        Iterator<LivingEntity> iterator = entitiesHit.iterator();
        while (iterator.hasNext()) {
            LivingEntity target = iterator.next();
            float entityHitAngle = (float)HeartOfTitanium.getAngleBetweenEntities((Entity)this, (Entity)target);
            float entityAttackingAngle = this.f_19859_ % 360.0f - 180.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = this.m_20270_((Entity)target);
            if (!((entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && !target.m_20147_())) continue;
            float dmg = (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)(target.m_21233_() * healthPercentDamage));
            if (target instanceof Monster) {
                dmg += target.m_21233_() * healthPercentDamage * 1.5f;
            }
            boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), dmg);
            if (target instanceof Player && target.m_21254_() && shieldBreakTicks > 0) {
                HeartOfTitanium.disableShield(target, shieldBreakTicks);
            }
            if (!flag || !(airborne > 0.0f)) continue;
            target.m_20256_(target.m_20184_().m_82520_(0.0, (double)airborne, 0.0));
        }
        return;
    }

    private void bubbleSweep(double range, int amount, double angleFrom, double angleTo) {
        double Yrot = (double)(-this.f_20883_ / 180.0f) * Math.PI;
        for (double i = 0.0; i < (double)amount; i += 1.0) {
            double angleTrue = -(angleFrom + (angleTo - angleFrom) * i / (double)amount + this.middleRandom(5.0)) / 180.0 * Math.PI;
            for (int j = 0; j < 4; ++j) {
                double x = this.m_20185_() + range * Math.sin(Yrot + angleTrue) + this.middleRandom(0.3);
                double y = this.m_20227_(0.55) + this.middleRandom(0.3);
                double z = this.m_20189_() + range * Math.cos(Yrot + angleTrue) + this.middleRandom(0.3);
                this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), x, y, z, this.middleRandom(0.2), this.middleRandom(0.2), this.middleRandom(0.2));
            }
        }
    }

    private void riptide() {
        Vec3 move = this.m_20184_();
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 7; ++i) {
                double x = this.m_20185_() + move.f_82479_ * (double)j / 5.0 + this.middleRandom((double)this.m_20205_() * 2.0);
                double y = this.m_20227_(0.4) + move.f_82480_ * (double)j / 5.0 + this.middleRandom((double)this.m_20206_() * 0.6);
                double z = this.m_20189_() + move.f_82481_ * (double)j / 5.0 + this.middleRandom((double)this.m_20205_() * 2.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123774_, x, y, z, this.middleRandom(0.25), Math.random() * 0.5, this.middleRandom(0.25));
            }
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 1.0, 1.0).m_82386_(move.f_82479_ * (double)j / 5.0, move.f_82480_ * (double)j / 5.0, move.f_82481_ * (double)j / 5.0));
            Iterator var = entities.iterator();
            if (!var.hasNext()) continue;
            while (var.hasNext()) {
                Entity target = (Entity)var.next();
                if (!(!(target instanceof LivingEntity) || target instanceof Drowned || target instanceof HeartOfTitanium || this.ignoreEntities.contains(target) || target.m_20147_())) {
                    Player player;
                    this.ignoreEntities.add(target);
                    if (target.m_20147_()) continue;
                    this.m_5496_(SoundEvents.f_11666_, 1.5f, 0.5f + (float)this.f_19796_.m_188503_(2) * 0.2f);
                    float dmg = (float)(this.m_21133_(Attributes.f_22281_) * move.m_82553_()) / (this.activated ? 4.0f : 4.5f) + (this.activated ? 3.0f : 0.0f);
                    boolean flag = target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this), dmg);
                    if (flag) {
                        LightningBolt lightningbolt;
                        if (this.activated && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)target.m_20183_()));
                            this.m_9236_().m_7967_((Entity)lightningbolt);
                        }
                        target.m_246865_(move.m_82490_(0.25));
                    } else {
                        target.m_246865_(move.m_82490_(0.1));
                    }
                    if (target instanceof Player && (player = (Player)target).m_21254_()) {
                        HeartOfTitanium.disableShield((LivingEntity)player, 125);
                        this.m_5634_((float)move.m_82553_() / 2.0f);
                    } else if (this.activated) {
                        this.m_5634_(0.5f);
                    }
                }
                if (!(target instanceof Drowned)) continue;
                this.ignoreEntities.add(target);
                target.m_246865_(move.m_82490_(0.1));
            }
        }
    }

    private double middleRandom(double range) {
        return range * (Math.random() - 0.5);
    }

    public void m_6504_(LivingEntity entity, float time) {
        if (!this.m_9236_().f_46443_) {
            double modifier = 1.0 - (double)(this.minHealth / this.m_21233_()) + (this.activated ? 0.5 : 0.0);
            WaterTrident trident = new WaterTrident(this.m_9236_(), (LivingEntity)this);
            double d0 = entity.m_20185_() - this.m_20185_();
            double d1 = entity.m_20227_(0.4) - trident.m_20186_();
            double d2 = entity.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            trident.m_36781_(1.5 + modifier * 2.0);
            trident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, this.activated ? 1.9f : 1.7f, 10 - this.m_9236_().m_46791_().m_19028_() * 3);
            this.m_5496_(SoundEvents.f_11821_, 1.2f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)trident);
        }
    }

    public void performingDirectAttack(LivingEntity entity) {
        if (!this.m_9236_().f_46443_) {
            double modifier = 1.0 - (double)(this.minHealth / this.m_21233_()) + (this.activated ? 0.5 : 0.0);
            WaterTrident trident = new WaterTrident(this.m_9236_(), (LivingEntity)this, true);
            trident.m_146884_(this.randomPos);
            double d0 = entity.m_20185_() - this.randomPos.f_82479_;
            double d1 = entity.m_20227_(0.6) - this.randomPos.f_82480_;
            double d2 = entity.m_20189_() - this.randomPos.f_82481_;
            trident.m_20242_(true);
            trident.m_36781_(1.0 + modifier * 1.5);
            trident.m_6686_(d0, d1, d2, this.activated ? 1.8f : 1.75f, (float)(7.0 - (double)(this.m_9236_().m_46791_().m_19028_() * 2) * Math.random()));
            this.m_5496_(SoundEvents.f_11821_, 1.1f, 1.2f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)trident);
        }
    }

    private void bubblePattern(double range, double radius, double percent, Vec3 pos) {
        double Yrot = (double)(-this.f_20883_ / 180.0f) * Math.PI;
        for (double i = 0.0; i < 24.0; i += 1.0) {
            double x = pos.f_82479_ + range * Math.sin(Yrot) + radius * Math.sin(0.2617993877991494 * i) * Math.cos(Yrot);
            double y = pos.f_82480_ + radius * Math.cos(0.2617993877991494 * i);
            double z = pos.f_82481_ + range * Math.cos(Yrot) - radius * Math.sin(0.2617993877991494 * i) * Math.sin(Yrot);
            for (int j = 0; j < 2 && Math.random() <= percent; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void bubbleRing(double height, double radius, double percent) {
        for (double i = 0.0; i < 24.0; i += 1.0) {
            double x = this.m_20185_() + radius * Math.sin(0.2617993877991494 * i);
            double y = this.m_20227_(0.5) + height;
            double z = this.m_20189_() - radius * Math.cos(0.2617993877991494 * i);
            if (!(Math.random() <= percent)) continue;
            this.m_9236_().m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void randomPosBuild() {
        BlockPos blockPos;
        BlockState state;
        int counter = 0;
        do {
            this.randomPos = this.m_20182_().m_82549_(new Vec3(this.middleRandom(8.0), this.middleRandom(8.0), this.middleRandom(8.0)));
            blockPos = new BlockPos((int)Math.floor(this.randomPos.f_82479_), (int)Math.floor(this.randomPos.f_82480_), (int)Math.floor(this.randomPos.f_82481_));
        } while ((state = this.m_9236_().m_8055_(blockPos)).m_60815_() && ++counter < 128);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SWEEP_ATTACK, TRIDENT_SPAWN, RIPTIDE_ATTACK, TRACE, TRANSFORM};
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("minHealth", this.minHealth);
        tag.m_128379_("activated", this.getActivated());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("minHealth")) {
            this.minHealth = tag.m_128457_("minHealth");
        }
        if (tag.m_128441_("activated")) {
            this.setActivated(tag.m_128471_("activated"));
        }
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.bossEvent.setId(this.m_20148_());
    }

    public boolean getActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVATED);
    }

    public void setActivated(boolean flag) {
        this.f_19804_.m_135381_(DATA_ACTIVATED, (Object)flag);
    }

    public void m_6593_(@Nullable Component tag) {
        super.m_6593_(tag);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    static class WaterMoveControl
    extends MoveControl {
        public WaterMoveControl(HeartOfTitanium entity) {
            super((Mob)entity);
        }

        public void m_8126_() {
            if (this.f_24974_.m_20069_()) {
                if (this.f_24981_ == MoveControl.Operation.STRAFE) {
                    float delZ;
                    float targetSpeed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) / 3.0f;
                    float forwards = this.f_24979_;
                    float right = this.f_24980_;
                    float f4 = Math.max(Mth.m_14116_((float)(forwards * forwards + right * right)), 1.0f);
                    f4 = targetSpeed / f4;
                    float sin = Mth.m_14031_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                    float cos = Mth.m_14089_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                    float delX = (forwards *= f4) * cos - (right *= f4) * sin;
                    if (!this.m_24996_(delX, delZ = right * cos + forwards * sin)) {
                        this.f_24979_ = 1.0f;
                        this.f_24980_ = 0.0f;
                    }
                    float modifiedSpeed = Mth.m_14179_((float)0.125f, (float)this.f_24974_.m_6113_(), (float)targetSpeed);
                    this.f_24974_.m_7910_(modifiedSpeed);
                    this.f_24974_.m_21564_(this.f_24979_);
                    this.f_24974_.m_21570_(this.f_24980_);
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    double deltaX = this.f_24975_ - this.f_24974_.m_20185_();
                    double deltaZ = this.f_24977_ - this.f_24974_.m_20189_();
                    double deltaY = this.f_24976_ - this.f_24974_.m_20186_();
                    double distanceSqr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                    if (distanceSqr < 2.500000277905201E-7) {
                        this.f_24974_.m_21564_(0.0f);
                        return;
                    }
                    double distance = Math.sqrt(distanceSqr) * 2.0;
                    float rot = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), rot, 90.0f));
                    float targetSpeed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                    float modifiedSpeed = Mth.m_14179_((float)0.125f, (float)this.f_24974_.m_6113_(), (float)targetSpeed);
                    this.f_24974_.m_7910_(modifiedSpeed);
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_((double)modifiedSpeed * deltaX / distance, (double)modifiedSpeed * deltaY / distance * 2.0, (double)modifiedSpeed * deltaZ / distance));
                }
            } else {
                super.m_8126_();
            }
        }

        private boolean m_24996_(float x, float z) {
            PathNavigation pathnavigation = this.f_24974_.m_21573_();
            NodeEvaluator nodeevaluator = pathnavigation.m_26575_();
            return nodeevaluator.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)x)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)z))) == BlockPathTypes.WALKABLE;
        }
    }

    static class SweepAttack
    extends AnimationGoal<HeartOfTitanium> {
        private int timeToRecalcPath = 0;
        private boolean movable = false;
        private final boolean escape;
        private int escapeTime = 0;
        private final float modifier;

        protected SweepAttack(HeartOfTitanium entity, Animation animation, boolean escape, float num) {
            super(entity, animation);
            this.escape = escape;
            this.modifier = num;
        }

        @Override
        public boolean m_8036_() {
            this.escapeTime = Math.max(0, --this.escapeTime);
            return super.m_8036_() && this.escapeTime == 0;
        }

        @Override
        public boolean m_8045_() {
            LivingEntity target = ((HeartOfTitanium)this.entity).m_5448_();
            return target != null && ((HeartOfTitanium)this.entity).m_20270_((Entity)target) < 3.5f;
        }

        public void m_8056_() {
            super.m_8056_();
            ((HeartOfTitanium)this.entity).m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.escape) {
                this.escapeTime += 30;
                Vec3 delta = ((HeartOfTitanium)this.entity).m_20252_(0.0f).m_82490_(10.0);
                ((HeartOfTitanium)this.entity).m_21573_().m_26519_(((HeartOfTitanium)this.entity).m_20185_() + delta.f_82479_, ((HeartOfTitanium)this.entity).m_20227_(0.8) + delta.f_82480_, ((HeartOfTitanium)this.entity).m_20189_() + delta.f_82481_, (double)0.8f);
            } else {
                ((HeartOfTitanium)this.entity).m_21573_().m_26573_();
            }
        }

        public void m_8037_() {
            LivingEntity target = ((HeartOfTitanium)this.entity).m_5448_();
            double verSpeed = 0.01;
            if (target != null) {
                ((HeartOfTitanium)this.entity).m_21563_().m_24960_((Entity)target, 5.0f, 5.0f);
                ((HeartOfTitanium)this.entity).m_146922_(((HeartOfTitanium)this.entity).f_20886_);
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.m_183277_(10);
                    if (((HeartOfTitanium)this.entity).m_20270_((Entity)target) > 3.0f || ((HeartOfTitanium)this.entity).m_20186_() <= target.m_20186_()) {
                        this.movable = true;
                        ((HeartOfTitanium)this.entity).m_21573_().m_26519_(target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), (double)this.modifier);
                    }
                    if (this.movable && ((HeartOfTitanium)this.entity).m_20270_((Entity)target) < 2.0f) {
                        this.movable = false;
                        ((HeartOfTitanium)this.entity).m_21573_().m_26573_();
                    }
                }
                if (((HeartOfTitanium)this.entity).m_20186_() < target.m_20186_() + 0.5) {
                    verSpeed = 0.03;
                } else if (((HeartOfTitanium)this.entity).m_20186_() > target.m_20186_() + 2.5) {
                    verSpeed = -0.01;
                }
            }
            ((HeartOfTitanium)this.entity).m_246865_(new Vec3(0.0, verSpeed, 0.0));
        }
    }

    static class TitandentAttackGoal
    extends AnimationGoal<HeartOfTitanium> {
        private LivingEntity target;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public TitandentAttackGoal(HeartOfTitanium entity, Animation animation) {
            super(entity, animation);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingentity = ((HeartOfTitanium)this.entity).m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public boolean m_8045_() {
            return this.m_8036_() || this.target.m_6084_() && !((HeartOfTitanium)this.entity).m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            ((HeartOfTitanium)this.entity).m_21561_(true);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = ((HeartOfTitanium)this.entity).m_5448_();
            if (target != null) {
                double distanceSqr = ((HeartOfTitanium)this.entity).m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                boolean flag = ((HeartOfTitanium)this.entity).m_21574_().m_148306_((Entity)target);
                if (flag != this.seeTime > 0) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                float attackRadiusSqr = 72.0f;
                if (!(distanceSqr > (double)attackRadiusSqr) && this.seeTime >= 5) {
                    ((HeartOfTitanium)this.entity).m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    ((HeartOfTitanium)this.entity).m_21573_().m_5624_((Entity)target, 0.5);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)((HeartOfTitanium)this.entity).m_217043_().m_188501_() < 0.3) {
                        boolean bl = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)((HeartOfTitanium)this.entity).m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distanceSqr > (double)(attackRadiusSqr * 0.9f)) {
                        this.strafingBackwards = false;
                    } else if (distanceSqr < (double)(attackRadiusSqr * 0.8f)) {
                        this.strafingBackwards = true;
                    }
                    ((HeartOfTitanium)this.entity).m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.4f, this.strafingClockwise ? 0.5f : -0.5f);
                    ((HeartOfTitanium)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                    ((HeartOfTitanium)this.entity).f_20883_ = ((HeartOfTitanium)this.entity).m_146908_();
                } else {
                    ((HeartOfTitanium)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
                double verSpeed = -0.01;
                if (((HeartOfTitanium)this.entity).m_20186_() < target.m_20186_() + 0.5) {
                    verSpeed = 0.03;
                } else if (((HeartOfTitanium)this.entity).m_20186_() > target.m_20186_() + 2.5) {
                    verSpeed = -0.02;
                }
                ((HeartOfTitanium)this.entity).m_246865_(new Vec3(0.0, verSpeed, 0.0));
            }
        }
    }
}

