/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.compat.twilightforest;

import com.auviotre.makit_better.init.MKBItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.block.LightableBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.init.TFSounds;
import twilightforest.item.PeacockFanItem;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.util.WorldUtil;

public class CherryFanItem
extends PeacockFanItem {
    public CherryFanItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add(MKBItems.WIP_TEXT);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        Vec3 lookVec;
        boolean flag;
        ItemStack stack = player.m_21120_(hand);
        boolean bl = flag = !player.m_20096_() && !player.m_6069_() && player.getCapability(CapabilityList.FEATHER_FAN_FALLING).map(FeatherFanFallCapability::getFalling).orElse(true) == false;
        if (!level.m_5776_()) {
            int fanned = this.doFan(level, player) / 2;
            stack.m_41622_(fanned + 1, (LivingEntity)player, user -> user.m_21190_(hand));
            if (flag) {
                player.getCapability(CapabilityList.FEATHER_FAN_FALLING).ifPresent(cap -> cap.setFalling(true));
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_21255_()) {
            Vec3 look = player.m_20154_();
            lookVec = player.m_20184_();
            player.m_20256_(lookVec.m_82520_(look.m_7096_() * 0.16 + (look.m_7096_() * 2.0 - lookVec.m_7096_()) * 0.5, look.m_7098_() * 0.16 + (look.m_7098_() * 2.0 - lookVec.m_7098_()) * 0.5 + 0.6, look.m_7094_() * 0.16 + (look.m_7094_() * 2.0 - lookVec.m_7094_()) * 0.5));
        }
        if (flag) {
            Vec3 vec3 = player.m_20184_();
            player.m_20334_(vec3.m_7096_() * 1.5, 1.6, vec3.m_7094_() * 1.5);
        } else {
            AABB fanBox = this.getEffectAABB(player, 1.5, 2.0);
            lookVec = player.m_20154_();
            for (int i = 0; i < 30; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, fanBox.f_82288_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82291_ - fanBox.f_82288_), fanBox.f_82289_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82292_ - fanBox.f_82289_), fanBox.f_82290_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82293_ - fanBox.f_82290_), lookVec.m_7096_(), lookVec.m_7098_(), lookVec.m_7094_());
            }
        }
        player.m_5496_((SoundEvent)TFSounds.FAN_WHOOSH.get(), 1.0f + level.m_213780_().m_188501_(), level.m_213780_().m_188501_() * 0.7f + 0.3f);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private int doFan(Level level, Player player) {
        AABB fanBox = this.getEffectAABB(player, 3.5, 3.0);
        return this.fanBlocksInAABB(level, fanBox, player) + this.fanEntitiesInAABB(level, player, fanBox);
    }

    private AABB getEffectAABB(Player player, double range, double radius) {
        Vec3 srcVec = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 lookVec = player.m_20154_().m_82490_(range);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_(), lookVec.m_7098_(), lookVec.m_7094_());
        return new AABB(destVec.m_7096_() - radius, destVec.m_7098_() - radius, destVec.m_7094_() - radius, destVec.m_7096_() + radius, destVec.m_7098_() + radius, destVec.m_7094_() + radius);
    }

    private int fanEntitiesInAABB(Level level, Player player, AABB fanBox) {
        Vec3 moveVec = player.m_20154_().m_82490_(2.0);
        Item fan = player.m_21211_().m_41720_();
        int fannedEntities = 0;
        for (Entity entity : level.m_45976_(Entity.class, fanBox)) {
            ServerPlayer pushedPlayer;
            if (entity.m_6094_() || entity instanceof ItemEntity || entity instanceof Projectile) {
                entity.m_20334_(moveVec.m_7096_(), moveVec.m_7098_(), moveVec.m_7094_());
                ++fannedEntities;
            }
            if (!(entity instanceof ServerPlayer) || (pushedPlayer = (ServerPlayer)entity) == player || pushedPlayer.m_6144_()) continue;
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> pushedPlayer), (Object)new ThrowPlayerPacket(moveVec.m_7096_(), moveVec.m_7098_(), moveVec.m_7094_()));
            player.m_36335_().m_41524_(fan, 40);
            fannedEntities += 2;
        }
        return fannedEntities;
    }

    private int fanBlocksInAABB(Level level, AABB box, Player player) {
        int fan = 0;
        for (BlockPos pos : WorldUtil.getAllInBB((AABB)box)) {
            fan += this.fanBlock(level, pos, player);
        }
        return fan;
    }

    private int fanBlock(Level level, BlockPos pos, Player player) {
        int cost = 0;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof FlowerBlock) {
            if (level.m_213780_().m_188503_(3) == 0 && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))) {
                level.m_46961_(pos, true);
                ++cost;
            }
        } else if (state.m_60734_() instanceof AbstractCandleBlock && ((Boolean)state.m_61143_((Property)AbstractCandleBlock.f_151895_)).booleanValue()) {
            AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
        } else {
            Block block = state.m_60734_();
            if (block instanceof LightableBlock) {
                LightableBlock lightable = (LightableBlock)block;
                if (state.m_61143_((Property)LightableBlock.LIGHTING) != LightableBlock.Lighting.NONE) {
                    lightable.extinguish(null, state, (LevelAccessor)level, pos);
                }
            }
        }
        return cost;
    }
}

