/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.compat.jei;

import com.auviotre.makit_better.compat.jei.MKBJEIPlugin;
import com.auviotre.makit_better.init.MKBBlocks;
import com.auviotre.makit_better.recipes.CoralTransformRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoralTransformRecipeCategory
implements IRecipeCategory<CoralTransformRecipe> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("makit_better", "textures/gui/coral_transform_jei.png");
    public static final ResourceLocation UID = new ResourceLocation("makit_better", "coral_transform");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;

    public CoralTransformRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GUI_TEXTURE, 0, 0, 120, 58);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MKBBlocks.CORAL_MUSH_BLOCK.get()));
        this.arrow = guiHelper.drawableBuilder(GUI_TEXTURE, 120, 0, 20, 16).buildAnimated(360, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(CoralTransformRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 52, 20);
    }

    public RecipeType<CoralTransformRecipe> getRecipeType() {
        return MKBJEIPlugin.CORAL_TRANSFORM_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.makit_better.coral_transform.jei_title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoralTransformRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 21).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 21).addItemStack(recipe.getResult());
    }

    public List<Component> getTooltipStrings(CoralTransformRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (MKBJEIPlugin.isCursorInsideBounds(52, 20, 20, 16, mouseX, mouseY)) {
            ArrayList<Component> tooltipStrings = new ArrayList<Component>();
            int cookTime = recipe.getTransformTime();
            if (cookTime > 0) {
                int time = cookTime / 20;
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.makit_better.coral_transform.jei_category.time", (Object[])new Object[]{time}));
            }
            return tooltipStrings;
        }
        return Collections.emptyList();
    }
}

