/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.cilent.renderers.projectile;

import com.auviotre.makit_better.cilent.models.MKBModelLayers;
import com.auviotre.makit_better.cilent.models.entity.projectile.PrismarineFragmentModel;
import com.auviotre.makit_better.entities.projectile.PrismarineFragment;
import com.auviotre.makit_better.items.TideChainItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PrismarineFragmentRenderer
extends EntityRenderer<PrismarineFragment> {
    private static final ResourceLocation PRISMARINE_FRAGMENT_TEXTURE = new ResourceLocation("makit_better", "textures/entity/projectiles/prismarine_fragment.png");
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("makit_better", "textures/entity/projectiles/prismarine_fragment_chain.png");
    private final PrismarineFragmentModel model;
    private static final RenderType CHAIN_LAYER = RenderType.m_110458_((ResourceLocation)CHAIN_TEXTURE);

    public PrismarineFragmentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PrismarineFragmentModel(context.m_174023_(MKBModelLayers.PRISMARINE_FRAGMENT));
    }

    public void render(PrismarineFragment entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)tickDelta, (float)(-entity.renderYRotO), (float)(-entity.getRenderYRot()))));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)tickDelta, (float)entity.renderXRotO, (float)entity.getRenderXRot())));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        Entity fromEntity = entity.m_19749_();
        float x = (float)Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_());
        float y = (float)Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_());
        float z = (float)Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_());
        if (fromEntity != null) {
            Vec3 distVec = this.getPositionOfPriorMob(fromEntity, tickDelta, entity.hand).m_82492_((double)x, (double)y, (double)z);
            PrismarineFragmentRenderer.renderChainCube(distVec, tickDelta, entity.f_19797_, poseStack, bufferSource, 0xF000F0);
        }
        poseStack.m_85849_();
    }

    private Vec3 getPositionOfPriorMob(Entity mob, float partialTicks, InteractionHand hand) {
        double mobX = Mth.m_14139_((double)partialTicks, (double)mob.f_19854_, (double)mob.m_20185_());
        double mobY = Mth.m_14139_((double)partialTicks, (double)mob.f_19855_, (double)mob.m_20186_());
        double mobZ = Mth.m_14139_((double)partialTicks, (double)mob.f_19856_, (double)mob.m_20189_());
        float f3 = 0.0f;
        if (mob instanceof Player) {
            int i;
            Player player = (Player)mob;
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            int n = i = hand == InteractionHand.MAIN_HAND ? 1 : -1;
            if (player.m_21205_().m_41720_() instanceof TideChainItem) {
                i = 1;
            } else if (player.m_21206_().m_41720_() instanceof TideChainItem) {
                i = -1;
            }
            double d2 = (double)i * 0.35;
            if (this.f_114476_.f_114360_.m_92176_().m_90612_() && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.92f, -1.2f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.25f);
                vec3 = vec3.m_82535_(-f1 * 0.35f);
                mobX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                mobY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                mobZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20206_();
            } else {
                mobX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - (double)Mth.m_14089_((float)f2) * d2 - (double)Mth.m_14031_((float)f2) * 0.2;
                mobY = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                mobZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - (double)Mth.m_14031_((float)f2) * d2 + (double)Mth.m_14089_((float)f2) * 0.2;
                f3 = player.m_6047_() ? -0.1575f : -0.4f;
            }
        }
        return new Vec3(mobX, mobY + (double)f3, mobZ);
    }

    public static void renderChainCube(Vec3 from, float tickDelta, int age, PoseStack poseStack, MultiBufferSource buffer, int light) {
        float lengthXZ = Mth.m_14116_((float)((float)(from.f_82479_ * from.f_82479_ + from.f_82481_ * from.f_82481_)));
        float squaredLength = (float)(from.f_82479_ * from.f_82479_ + from.f_82480_ * from.f_82480_ + from.f_82481_ * from.f_82481_);
        float length = Mth.m_14116_((float)squaredLength);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(from.f_82481_, from.f_82479_)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(lengthXZ, from.f_82480_)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(20.0f));
        poseStack.m_85836_();
        poseStack.m_85837_(0.015, -0.2, 0.0);
        VertexConsumer vertexConsumer = buffer.m_6299_(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f - ((float)age + tickDelta) * 0.01f;
        float maxV = length / 8.0f - ((float)age + tickDelta) * 0.01f;
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        poseStack.m_85837_(-0.015, -0.2, 0.0);
        entry = poseStack.m_85850_();
        matrix4f = entry.m_252922_();
        matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(PrismarineFragment entity) {
        return PRISMARINE_FRAGMENT_TEXTURE;
    }
}

