/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.cilent.models.entity;

import com.auviotre.makit_better.entities.SugarElf;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SugarElfModel
extends HierarchicalModel<SugarElf>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;

    public SugarElfModel(ModelPart modelPart) {
        super(RenderType::m_110473_);
        this.root = modelPart.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_wing = this.body.m_171324_("right_wing");
        this.left_wing = this.body.m_171324_("left_wing");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.5f, (float)0.0f));
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.99f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171488_(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-1.75f, (float)0.5f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(23, 6).m_171488_(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)1.75f, (float)0.5f, (float)0.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)0.6f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.6f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(SugarElf entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float degUnit = (float)Math.PI / 180;
        float f6 = ageInTicks * 20.0f * degUnit + limbSwing;
        float wingFlutter = Mth.m_14089_((float)f6) * 27.0f * degUnit + limbSwingAmount;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float bodyFly = ageInTicks * 9.0f * degUnit;
        float bodyRotate = Math.min(limbSwingAmount / 0.3f, 1.0f);
        float liftHandProgress = entity.getHoldingItemAnimationProgress(partialTick);
        this.head.f_104203_ = headPitch * degUnit;
        this.head.f_104204_ = netHeadYaw * degUnit;
        this.right_wing.f_104203_ = 25.0f * degUnit * (1.0f - bodyRotate);
        this.right_wing.f_104204_ = -45.0f * degUnit + wingFlutter;
        this.left_wing.f_104203_ = 25.0f * degUnit * (1.0f - bodyRotate);
        this.left_wing.f_104204_ = 45.0f * degUnit - wingFlutter;
        this.body.f_104203_ = bodyRotate * 45.0f * degUnit;
        float f18 = liftHandProgress * Mth.m_14179_((float)bodyRotate, (float)(-60.0f * degUnit), (float)(-65.0f * degUnit));
        this.root.f_104201_ += (float)Math.cos(bodyFly) * 0.25f * (1.0f - bodyRotate);
        this.right_arm.f_104203_ = f18;
        this.left_arm.f_104203_ = f18;
        float f19 = (1.0f - bodyRotate) * (1.0f - liftHandProgress);
        float f20 = 25.0f * degUnit - Mth.m_14089_((float)(bodyFly + 270.0f * degUnit)) * 13.5f * degUnit * f19;
        this.left_arm.f_104205_ = -f20;
        this.right_arm.f_104205_ = f20;
        this.right_arm.f_104204_ = 16.0f * degUnit * liftHandProgress;
        this.left_arm.f_104204_ = -16.0f * degUnit * liftHandProgress;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0625f, 0.1875f);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(this.right_arm.f_104203_));
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_252880_(0.0625f, 0.0f, 0.0f);
    }
}

