/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.cilent.models.entity;

import com.auviotre.makit_better.entities.HeartOfTitanium;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Entity;

public class HeartOfTitaniumModel
extends AdvancedEntityModel<HeartOfTitanium> {
    public final AdvancedModelBox root;
    public final AdvancedModelBox upper;
    public final AdvancedModelBox lower;
    public final AdvancedModelBox head;
    public final AdvancedModelBox body;
    public final AdvancedModelBox rightArm;
    public final AdvancedModelBox titandent;
    public final AdvancedModelBox pole;
    public final AdvancedModelBox base;
    public final AdvancedModelBox rightSpike;
    public final AdvancedModelBox middleSpike;
    public final AdvancedModelBox leftSpike;
    public final AdvancedModelBox tail;
    public final AdvancedModelBox core;
    public final AdvancedModelBox rightHead;
    public final AdvancedModelBox leftHead;
    public final AdvancedModelBox leftArm;
    public final AdvancedModelBox rightLeg;
    public final AdvancedModelBox leftLeg;
    private final ModelAnimator animator;
    private float swimAmount;

    private float toRadians(double num) {
        return (float)Math.toRadians(num);
    }

    public HeartOfTitaniumModel(float size) {
        this.texHeight = 64;
        this.texWidth = 64;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setPos(0.0f, 24.0f, 0.0f);
        this.upper = new AdvancedModelBox((AdvancedEntityModel)this, "upper");
        this.upper.setPos(0.0f, -12.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.upper);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head.setPos(0.0f, -12.0f, 0.0f);
        this.head.setTextureOffset(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, size);
        this.upper.addChild((BasicModelPart)this.head);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, "body");
        this.body.setPos(0.0f, -12.0f, 0.0f);
        this.body.setTextureOffset(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, size);
        this.upper.addChild((BasicModelPart)this.body);
        this.rightArm = new AdvancedModelBox((AdvancedEntityModel)this, "rightArm");
        this.rightArm.setPos(-5.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.rightArm, 0.0f, 0.0f, this.toRadians(4.0));
        this.rightArm.setTextureOffset(0, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, size);
        this.body.addChild((BasicModelPart)this.rightArm);
        this.titandent = new AdvancedModelBox((AdvancedEntityModel)this, "titandent");
        this.titandent.setPos(-1.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.titandent, this.toRadians(-90.0), 0.0f, 0.0f);
        this.rightArm.addChild((BasicModelPart)this.titandent);
        this.pole = new AdvancedModelBox((AdvancedEntityModel)this, "pole");
        this.pole.setTextureOffset(0, 39).addBox(-0.5f, -9.0f, -0.5f, 1.0f, 24.0f, 1.0f);
        this.titandent.addChild((BasicModelPart)this.pole);
        this.base = new AdvancedModelBox((AdvancedEntityModel)this, "base");
        this.pole.setTextureOffset(4, 32).addBox(-1.5f, 15.0f, -0.5f, 3.0f, 2.0f, 1.0f);
        this.titandent.addChild((BasicModelPart)this.base);
        this.rightSpike = new AdvancedModelBox((AdvancedEntityModel)this, "rightSpike");
        this.pole.setTextureOffset(4, 36).addBox(-2.5f, 16.0f, -0.5f, 1.0f, 4.0f, 1.0f);
        this.titandent.addChild((BasicModelPart)this.rightSpike);
        this.middleSpike = new AdvancedModelBox((AdvancedEntityModel)this, "middleSpike");
        this.pole.setTextureOffset(0, 33).addBox(-0.5f, 17.0f, -0.5f, 1.0f, 4.0f, 1.0f);
        this.titandent.addChild((BasicModelPart)this.middleSpike);
        this.leftSpike = new AdvancedModelBox((AdvancedEntityModel)this, "leftSpike");
        this.pole.setTextureOffset(4, 36).addBox(1.5f, 16.0f, -0.5f, 1.0f, 4.0f, 1.0f, true);
        this.titandent.addChild((BasicModelPart)this.leftSpike);
        this.core = new AdvancedModelBox((AdvancedEntityModel)this, "core");
        this.core.setPos(0.0f, 16.0f, 0.0f);
        this.setRotateAngle(this.core, 0.0f, 0.0f, this.toRadians(45.0));
        this.core.setTextureOffset(4, 61).addBox(-0.5f, -0.5f, -1.0f, 1.0f, 1.0f, 2.0f);
        this.titandent.addChild((BasicModelPart)this.core);
        this.rightHead = new AdvancedModelBox((AdvancedEntityModel)this, "rightHead");
        float xConst = (float)Math.sqrt(2.0) * 3.0f / 4.0f;
        float yConst = (float)Math.sqrt(2.0) * 13.0f / 4.0f - 1.0f;
        this.rightHead.setTextureOffset(4, 39).addBox(xConst, yConst, -0.5f, 1.0f, 1.0f, 1.0f);
        this.core.addChild((BasicModelPart)this.rightHead);
        this.leftHead = new AdvancedModelBox((AdvancedEntityModel)this, "leftHead");
        this.leftHead.setTextureOffset(4, 39).addBox(yConst, xConst, -0.5f, 1.0f, 1.0f, 1.0f);
        this.core.addChild((BasicModelPart)this.leftHead);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this, "tailCore");
        this.tail.setTextureOffset(4, 61).addBox(-18.5f, -18.5f, -1.0f, 1.0f, 1.0f, 2.0f).setTextureOffset(0, 39).addBox(-18.0f, -18.0f, -0.5f, 1.0f, 1.0f, 1.0f).setTextureOffset(0, 39).addBox(-19.0f, -19.0f, -0.5f, 1.0f, 1.0f, 1.0f);
        this.core.addChild((BasicModelPart)this.tail);
        this.leftArm = new AdvancedModelBox((AdvancedEntityModel)this, "leftArm");
        this.leftArm.setPos(5.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leftArm, 0.0f, 0.0f, this.toRadians(-4.0));
        this.leftArm.setTextureOffset(40, 16).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, size, true);
        this.body.addChild((BasicModelPart)this.leftArm);
        this.lower = new AdvancedModelBox((AdvancedEntityModel)this, "lower");
        this.lower.setPos(0.0f, -12.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.lower);
        this.rightLeg = new AdvancedModelBox((AdvancedEntityModel)this, "rightLeg");
        this.rightLeg.setPos(-1.9f, 0.0f, 0.0f);
        this.rightLeg.setTextureOffset(16, 48).addBox(-2.1f, -0.0f, -2.0f, 4.0f, 12.0f, 4.0f, size);
        this.lower.addChild((BasicModelPart)this.rightLeg);
        this.leftLeg = new AdvancedModelBox((AdvancedEntityModel)this, "leftLeg");
        this.leftLeg.setPos(1.9f, 0.0f, 0.0f);
        this.leftLeg.setTextureOffset(32, 48).addBox(-1.9f, -0.0f, -2.0f, 4.0f, 12.0f, 4.0f, size, true);
        this.lower.addChild((BasicModelPart)this.leftLeg);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public void prepareMobModel(HeartOfTitanium entity, float p_102862_, float p_102863_, float partialTicks) {
        this.swimAmount = entity.m_20998_(partialTicks);
        super.m_6839_((Entity)entity, p_102862_, p_102863_, partialTicks);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.upper, (Object)this.lower, (Object)this.head, (Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.titandent, (Object)this.pole, (Object)this.base, (Object[])new AdvancedModelBox[]{this.leftSpike, this.middleSpike, this.rightSpike, this.core, this.rightHead, this.leftHead, this.tail});
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public void setupAnim(HeartOfTitanium entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float walkSpeed = 0.75f;
        float walkDegree = 0.8f;
        this.walk(this.leftLeg, walkSpeed, walkDegree, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        if (entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.walk(this.leftArm, walkSpeed, walkDegree, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
            this.walk(this.rightArm, walkSpeed, walkDegree, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        }
        this.setRotateAngle(this.upper, this.toRadians(90.0f * this.swimAmount), 0.0f, 0.0f);
        this.setRotateAngle(this.lower, this.toRadians(90.0f * this.swimAmount), 0.0f, 0.0f);
        this.setRotateAngle(this.head, this.toRadians(headPitch + this.swimAmount * (-50.0f - headPitch)), this.toRadians(netHeadYaw), 0.0f);
        float swimTick = ageInTicks % 30.0f;
        if (swimTick < 16.0f) {
            float part = swimTick / 16.0f;
            this.setRotateAngle(this.rightArm, 0.0f, this.toRadians(180.0f * this.swimAmount), this.toRadians(180.0f - 108.0f * part) * this.swimAmount);
            this.setRotateAngle(this.leftArm, 0.0f, -this.toRadians(180.0f * this.swimAmount), -this.toRadians(180.0f - 108.0f * part) * this.swimAmount);
        } else if (swimTick >= 16.0f && swimTick < 24.0f) {
            float part = (swimTick - 16.0f) / 8.0f;
            this.setRotateAngle(this.rightArm, this.toRadians(90.0f * part) * this.swimAmount, this.toRadians(180.0f * this.swimAmount), this.toRadians(72.0f + 108.0f * part) * this.swimAmount);
            this.setRotateAngle(this.leftArm, this.toRadians(90.0f * part) * this.swimAmount, -this.toRadians(180.0f * this.swimAmount), -this.toRadians(72.0f + 108.0f * part) * this.swimAmount);
        } else if (swimTick >= 24.0f && swimTick < 30.0f) {
            float part = (30.0f - swimTick) / 6.0f;
            this.setRotateAngle(this.rightArm, this.toRadians(90.0f * part) * this.swimAmount, this.toRadians(180.0f * this.swimAmount), this.toRadians(180.0f * this.swimAmount));
            this.setRotateAngle(this.leftArm, this.toRadians(90.0f * part) * this.swimAmount, -this.toRadians(180.0f * this.swimAmount), -this.toRadians(180.0f * this.swimAmount));
        }
        this.animate(entity);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(HeartOfTitanium.SWEEP_ATTACK);
        this.animator.setStaticKeyframe(3);
        this.animator.startKeyframe(9);
        this.animator.rotate(this.upper, this.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(15.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(20.0), this.toRadians(15.0), 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-15.0), this.toRadians(32.5), 0.0f);
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.upper, this.toRadians(2.5), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(-25.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-50.0), this.toRadians(-40.0), this.toRadians(55.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-15.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(7);
        this.animator.rotate(this.upper, this.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-75.0), this.toRadians(-50.0), this.toRadians(85.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.upper, this.toRadians(2.5), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(20.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(37.5), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-8.0), this.toRadians(1.0), this.toRadians(40.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-22.5));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(HeartOfTitanium.TRIDENT_SPAWN);
        this.animator.startKeyframe(6);
        this.animator.rotate(this.lower, 0.0f, this.toRadians(-35.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(-55.0), 0.0f);
        this.animator.rotate(this.leftArm, 0.0f, this.toRadians(-18.0), this.toRadians(-12.0));
        this.animator.rotate(this.rightArm, this.toRadians(-65.0), this.toRadians(45.5), this.toRadians(-1.25));
        this.animator.rotate(this.titandent, this.toRadians(63.0), this.toRadians(-0.4), this.toRadians(-2.5));
        this.animator.move(this.titandent, 0.0f, 0.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(16);
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(HeartOfTitanium.RIPTIDE);
        this.animator.setStaticKeyframe(3);
        this.animator.startKeyframe(7);
        this.animator.rotate(this.upper, this.toRadians(7.5), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(67.5), this.toRadians(26.0), this.toRadians(30.0));
        this.animator.move(this.titandent, -1.0f, -1.0f, -3.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-70.0), this.toRadians(-37.5), this.toRadians(18.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.upper, this.toRadians(75.0), 0.0f, 0.0f);
        this.animator.rotate(this.lower, this.toRadians(75.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, this.toRadians(-70.0), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(62.5), this.toRadians(-28.0), this.toRadians(33.0));
        this.animator.move(this.titandent, -1.0f, -1.0f, -3.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-157.0), this.toRadians(-37.5), this.toRadians(18.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(4);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(HeartOfTitanium.RIPTIDE_ATTACK);
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(8);
        this.animator.rotate(this.upper, this.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(15.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(20.0), this.toRadians(15.0), 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-15.0), this.toRadians(32.5), 0.0f);
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.upper, this.toRadians(2.5), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(-25.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-50.0), this.toRadians(-40.0), this.toRadians(55.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-15.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.upper, this.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-75.0), this.toRadians(-50.0), this.toRadians(85.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.upper, this.toRadians(2.5), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, this.toRadians(20.0), 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(37.5), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-8.0), this.toRadians(1.0), this.toRadians(40.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-22.5));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.startKeyframe(4);
        this.animator.rotate(this.upper, this.toRadians(7.5), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(67.5), this.toRadians(26.0), this.toRadians(30.0));
        this.animator.move(this.titandent, -1.0f, -1.0f, -3.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-70.0), this.toRadians(-37.5), this.toRadians(18.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.upper, this.toRadians(75.0), 0.0f, 0.0f);
        this.animator.rotate(this.lower, this.toRadians(75.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, this.toRadians(-70.0), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(62.5), this.toRadians(-28.0), this.toRadians(33.0));
        this.animator.move(this.titandent, -1.0f, -1.0f, -3.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-157.0), this.toRadians(-37.5), this.toRadians(18.0));
        this.animator.rotate(this.leftArm, 0.0f, 0.0f, this.toRadians(-7.5));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.resetKeyframe(4);
        this.animator.setAnimation(HeartOfTitanium.TRACE);
        this.animator.startKeyframe(6);
        this.animator.rotate(this.head, this.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(41.0), this.toRadians(13.0), this.toRadians(12.0));
        this.animator.rotate(this.rightArm, this.toRadians(-140.0), this.toRadians(-15.0), this.toRadians(17.0));
        this.animator.rotate(this.leftArm, this.toRadians(7.5), 0.0f, this.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(90);
        this.animator.resetKeyframe(4);
        this.animator.setAnimation(HeartOfTitanium.TRANSFORM);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.upper, this.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.lower, this.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, this.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.titandent, this.toRadians(18.0), this.toRadians(-10.0), this.toRadians(-3.0));
        this.animator.rotate(this.rightArm, this.toRadians(-65.0), this.toRadians(-54.0), this.toRadians(27.0));
        this.animator.rotate(this.leftArm, this.toRadians(-30.0), this.toRadians(46.0), this.toRadians(1.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.lower, this.toRadians(2.5), 0.0f, 0.0f);
        this.animator.rotate(this.head, this.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, this.toRadians(-80.0), this.toRadians(54.0), this.toRadians(26.0));
        this.animator.rotate(this.leftArm, this.toRadians(-80.0), this.toRadians(48.0), this.toRadians(17.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.resetKeyframe(5);
    }
}

