/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.blocks.entity;

import com.auviotre.makit_better.entities.HeartOfTitanium;
import com.auviotre.makit_better.init.MKBBlockEntityTypes;
import com.auviotre.makit_better.init.MKBParticleTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrismarineAltarBlockEntity
extends BlockEntity {
    ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };
    private int spawnTimer = 0;

    public PrismarineAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MKBBlockEntityTypes.PRISMARINE_ALTAR_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public void setSpawn(@Nullable Entity entity, ItemStack stack) {
        this.spawnTimer = 160;
        this.inventory.setStackInSlot(0, stack.m_41620_(1));
        if (this.f_58857_ != null) {
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
        }
        this.m_6596_();
    }

    public static void spawnTick(Level level, BlockPos blockPos, BlockState state, PrismarineAltarBlockEntity blockEntity) {
        if (!blockEntity.isEmpty() && blockEntity.spawnTimer-- == 1) {
            Vec3 pos = blockPos.m_252807_();
            HeartOfTitanium entity = new HeartOfTitanium(level);
            entity.m_6034_(pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_);
            level.m_7967_((Entity)entity);
            blockEntity.inventory.setStackInSlot(0, ItemStack.f_41583_);
            level.m_7260_(blockPos, state, state, 3);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_5594_(null, blockPos, SoundEvents.f_12521_, SoundSource.BLOCKS, 2.0f, 0.36f);
            PrismarineAltarBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos blockPos, BlockState state, PrismarineAltarBlockEntity blockEntity) {
        if (!blockEntity.isEmpty()) {
            double z;
            double y;
            double x;
            int i;
            --blockEntity.spawnTimer;
            Vec3 pos = blockPos.m_252807_();
            for (i = (160 - blockEntity.spawnTimer) / 10; i > 0; --i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_, pos.f_82480_ + (double)i / 4.0, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            if (blockEntity.spawnTimer < 80) {
                for (double i2 = 0.0; i2 < 24.0 && Math.random() < (double)(80 - blockEntity.spawnTimer) / 40.0; i2 += 1.0) {
                    x = pos.f_82479_ + 0.6 * Math.sin(0.2617993877991494 * i2);
                    y = pos.f_82480_ + 0.9;
                    z = pos.f_82481_ - 0.6 * Math.cos(0.2617993877991494 * i2);
                    level.m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
                }
            }
            if (blockEntity.spawnTimer < 50) {
                for (double i3 = 0.0; i3 < 30.0 && Math.random() < (double)(50 - blockEntity.spawnTimer) / 20.0; i3 += 1.0) {
                    x = pos.f_82479_ + 0.8 * Math.sin(0.2617993877991494 * i3);
                    y = pos.f_82480_ + 1.4;
                    z = pos.f_82481_ - 0.8 * Math.cos(0.2617993877991494 * i3);
                    level.m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
                }
            }
            if (blockEntity.spawnTimer == 0) {
                for (i = 0; i < 256; ++i) {
                    double theta = Math.random() * 2.0 * Math.PI;
                    double phi = (Math.random() - 0.5) * Math.PI;
                    double dx = Math.cos(theta) * Math.cos(phi) * 0.6;
                    double dy = Math.sin(phi) * 0.6;
                    double dz = Math.sin(theta) * Math.cos(phi) * 0.6;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + 0.8, pos.f_82481_, dx, dy, dz);
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, pos.f_82479_, pos.f_82480_ + 0.8, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        } else {
            blockEntity.spawnTimer = 160;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnTimer = tag.m_128441_("SpawnTimer") ? tag.m_128451_("SpawnTimer") : 0;
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        } else {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    private CompoundTag writeItem(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SpawnTimer", this.spawnTimer);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        this.writeItem(tag);
    }

    public CompoundTag m_5995_() {
        return this.writeItem(new CompoundTag());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(Objects.requireNonNull(packet.m_131708_()));
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

