/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.blocks.entity;

import com.auviotre.makit_better.entities.projectile.CoralStar;
import com.auviotre.makit_better.init.MKBBlockEntityTypes;
import com.auviotre.makit_better.init.MKBParticleTypes;
import com.auviotre.makit_better.init.MKBRecipeTypes;
import com.auviotre.makit_better.init.MKBSounds;
import com.auviotre.makit_better.recipes.CoralTransformRecipe;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoralMushBlockEntity
extends BlockEntity
implements WorldlyContainer {
    ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };
    private int progress = 0;
    private int time = 0;
    private final RecipeManager.CachedCheck<Container, CoralTransformRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)MKBRecipeTypes.CORAL_TRANSFORM.get()));

    public CoralMushBlockEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)MKBBlockEntityTypes.CORAL_MUSH_BLOCK_ENTITY.get(), blockPos, state);
    }

    public static void transformTick(Level level, BlockPos blockPos, BlockState state, CoralMushBlockEntity blockEntity) {
        boolean flag = false;
        ItemStack stackIn = blockEntity.inventory.getStackInSlot(0);
        if (!stackIn.m_41619_()) {
            SimpleContainer container;
            ItemStack result;
            flag = true;
            if (blockEntity.progress++ >= blockEntity.time && (result = blockEntity.quickCheck.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{stackIn})), level).map(arg_0 -> CoralMushBlockEntity.lambda$transformTick$0((Container)container, level, arg_0)).orElse(stackIn)).m_246617_(level.m_246046_())) {
                blockEntity.progress = 0;
                level.m_245747_(blockPos, (SoundEvent)MKBSounds.CORAL_MUSH_BLOCK_BREATHE.get(), SoundSource.BLOCKS, 1.0f, 0.6f, true);
                level.m_5594_(null, blockPos, (SoundEvent)MKBSounds.ITEM_GENERIC_POP.get(), SoundSource.BLOCKS, 1.0f, 1.5f);
                for (int i = 0; i < 4; ++i) {
                    level.m_7106_((ParticleOptions)MKBParticleTypes.BUBBLE.get(), (double)blockPos.m_123341_() + 0.4 + 0.2 * Math.random(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.4 + 0.2 * Math.random(), 0.0, 0.0, 0.0);
                }
                if (stackIn.m_41782_()) {
                    result.m_41751_(stackIn.m_41783_());
                    if (result.m_41720_() instanceof Vanishable) {
                        result.m_41721_(Math.max(0, result.m_41773_() - result.m_41776_() / 5));
                    }
                }
                Block.m_152435_((Level)level, (BlockPos)blockPos, (Direction)Direction.UP, (ItemStack)result);
                blockEntity.inventory.setStackInSlot(0, ItemStack.f_41583_);
                level.m_7260_(blockPos, state, state, 3);
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
            }
        }
        if (flag) {
            CoralMushBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos blockPos, BlockState state, CoralMushBlockEntity blockEntity) {
        ItemStack stackIn = blockEntity.inventory.getStackInSlot(0);
        if (!stackIn.m_41619_()) {
            if (Math.random() > 0.96) {
                level.m_245747_(blockPos, (SoundEvent)MKBSounds.CORAL_MUSH_BLOCK_BREATHE.get(), SoundSource.BLOCKS, 1.0f, 1.5f / (float)(Math.random() + 2.0), true);
            }
            double dx = 0.05 * (Math.random() - 0.5);
            double dy = 0.1 * Math.random();
            double dz = 0.05 * (Math.random() - 0.5);
            level.m_7106_(CoralStar.getParticle(), (double)blockPos.m_123341_() + Math.random(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + Math.random(), dx, dy, dz);
        }
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int p_18941_) {
        return null;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return null;
    }

    public ItemStack m_8016_(int p_18951_) {
        return null;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
    }

    public ItemStack popItem() {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        this.m_6596_();
        return stackInSlot;
    }

    public void addItem(@Nullable Entity entity, ItemStack stack, int time) {
        this.inventory.setStackInSlot(0, stack.m_41620_(1));
        this.progress = 0;
        this.time = time;
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)MKBSounds.CORAL_MUSH_BLOCK_BREATHE.get(), SoundSource.BLOCKS, 1.0f, 0.7f);
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
        }
        this.m_6596_();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Optional<CoralTransformRecipe> getRecipe(ItemStack stack) {
        return this.f_58857_ != null ? this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_) : Optional.empty();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        } else {
            this.inventory.deserializeNBT(tag);
        }
    }

    private CompoundTag writeItem(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        this.writeItem(tag);
    }

    public CompoundTag m_5995_() {
        return this.writeItem(new CompoundTag());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int[] m_7071_(Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int slot, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return direction == Direction.UP;
    }

    public void m_6211_() {
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
    }

    private static /* synthetic */ ItemStack lambda$transformTick$0(Container container, Level level, CoralTransformRecipe recipe) {
        return recipe.m_5874_(container, level.m_9598_());
    }
}

