/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.blocks;

import com.auviotre.makit_better.init.MKBBlocks;
import com.auviotre.makit_better.init.MKBItems;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoltenTitaniumCauldronBlock
extends AbstractCauldronBlock
implements CauldronInteraction {
    private boolean active = false;
    public static final Map<Item, CauldronInteraction> INTERACTION_MAP = CauldronInteraction.m_175617_();
    private static final VoxelShape INSIDE = MoltenTitaniumCauldronBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape INSIDE_WITH_BLOCK = MoltenTitaniumCauldronBlock.m_49796_((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)MoltenTitaniumCauldronBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{MoltenTitaniumCauldronBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), MoltenTitaniumCauldronBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape SHAPE_WITH_BLOCK = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)MoltenTitaniumCauldronBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{MoltenTitaniumCauldronBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), MoltenTitaniumCauldronBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE_WITH_BLOCK}), (BooleanOp)BooleanOp.f_82685_);
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final CauldronInteraction FILL_TITANIUM_BLOCK = (state, level, pos, player, hand, stack) -> MoltenTitaniumCauldronBlock.placeBlock(level, pos, player, hand, stack, (BlockState)((Block)MKBBlocks.MOLTEN_TITANIUM_CAULDRON.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    public static final CauldronInteraction EMPTY_TITANIUM_BLOCK = (state, level, pos, player, hand, stack) -> MoltenTitaniumCauldronBlock.dropResource(state, level, pos, player, hand, stack, new ItemStack((ItemLike)MKBBlocks.TITANIUM_BLOCK.get()), blockState -> ((Integer)state.m_61143_((Property)AGE)).equals(0));
    public static final CauldronInteraction FILL_MOLTEN_TITANIUM = (state, level, pos, player, hand, stack) -> CauldronInteraction.m_175618_((Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((Block)MKBBlocks.MOLTEN_TITANIUM_CAULDRON.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.f_11783_);
    public static final CauldronInteraction EMPTY_MOLTEN_TITANIUM = (state, level, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)MKBItems.MOLTEN_TITANIUM_BUCKET.get()), blockState -> ((Integer)state.m_61143_((Property)AGE)).equals(3), (SoundEvent)SoundEvents.f_11780_);

    public MoltenTitaniumCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(MoltenTitaniumCauldronBlock.moltenStageEmission()), INTERACTION_MAP);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static ToIntFunction<BlockState> moltenStageEmission() {
        return state -> (Integer)state.m_61143_((Property)AGE) * 3;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter getter, BlockPos blockPos, CollisionContext context) {
        if ((Integer)blockState.m_61143_((Property)AGE) > 0) {
            return SHAPE;
        }
        return SHAPE_WITH_BLOCK;
    }

    protected double m_142446_(BlockState blockState) {
        return 0.9375;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42544_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (this.m_151979_(state, blockPos, entity) && this.getAge(state, level, blockPos) > 0 && !level.m_5776_()) {
            ItemEntity item;
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (this.getAge(state, level, blockPos) == 3 && itemEntity.m_32055_().m_41720_().equals(MKBItems.ABYSS_PRISMARINE_UPGRADE_SMITHING_TEMPLATE.get())) {
                    itemEntity.m_32055_().m_41774_(1);
                    if (itemEntity.m_32055_().m_41619_()) {
                        itemEntity.m_146870_();
                    }
                    this.active = true;
                    MoltenTitaniumCauldronBlock.m_152435_((Level)level, (BlockPos)blockPos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)MKBItems.BIO_TITANIUM_UPGRADE_SMITHING_TEMPLATE.get()));
                    level.m_46597_(blockPos, Blocks.f_50256_.m_49966_());
                    level.m_247517_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS);
                    return;
                }
            }
            if (entity instanceof ItemEntity && (item = (ItemEntity)entity).m_32055_().m_41720_().equals(MKBItems.BIO_TITANIUM_UPGRADE_SMITHING_TEMPLATE.get())) {
                return;
            }
            entity.m_20254_(10);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        if (this.active) {
            this.active = false;
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)blockPos.m_123341_() + random.m_188501_()), (double)blockPos.m_7494_().m_123342_() + (double)random.m_188501_() * 0.1, (double)((float)blockPos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getAge(BlockState state, Level level, BlockPos blockPos) {
        return (Integer)state.m_61143_((Property)AGE);
    }

    public void m_213898_(BlockState state, ServerLevel serverlevel, BlockPos blockPos, RandomSource random) {
        if (serverlevel.isAreaLoaded(blockPos, 1)) {
            int max_age = AGE.m_6908_().size() - 1;
            int age = (Integer)state.m_61143_((Property)AGE);
            if (random.m_188503_(1) == 0) {
                BlockState below = serverlevel.m_8055_(blockPos.m_7495_());
                if (below.m_60713_(Blocks.f_50083_) || below.m_60819_().m_205070_(FluidTags.f_13132_)) {
                    if (age < max_age) {
                        serverlevel.m_46597_(blockPos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                    }
                } else if (age > 0) {
                    serverlevel.m_46597_(blockPos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Mth.m_14045_((int)(age - 1), (int)0, (int)max_age))));
                }
            }
        }
    }

    public InteractionResult m_175710_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        ItemStack itemStack = player.m_21120_(hand);
        CauldronInteraction interaction = INTERACTION_MAP.get(itemStack.m_41720_());
        return interaction.m_175710_(blockState, level, pos, player, hand, itemStack);
    }

    public boolean m_142596_(BlockState blockState) {
        return true;
    }

    static InteractionResult placeBlock(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state) {
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            level.m_46597_(pos, state);
            level.m_5594_(null, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157792_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    static InteractionResult dropResource(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack usedStack, ItemStack droppedStack, Predicate<BlockState> stateCondition) {
        if (!stateCondition.test(state)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            Item item = usedStack.m_41720_();
            player.m_36220_(Stats.f_12944_);
            if (!player.m_150110_().f_35937_) {
                MoltenTitaniumCauldronBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)droppedStack);
            }
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

