/*
 * Decompiled with CFR 0.152.
 */
package com.auviotre.makit_better.blocks;

import com.auviotre.makit_better.blocks.entity.CoralMushBlockEntity;
import com.auviotre.makit_better.init.MKBBlockEntityTypes;
import com.auviotre.makit_better.init.MKBItems;
import com.auviotre.makit_better.init.MKBSounds;
import com.auviotre.makit_better.recipes.CoralTransformRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class CoralMushBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public CoralMushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == Items.f_42446_ && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || stack.m_41720_() == Items.f_42447_ && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (blockEntity instanceof CoralMushBlockEntity) {
            CoralMushBlockEntity coralMushBlockEntity = (CoralMushBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (coralMushBlockEntity.m_7983_()) {
                    if (stack.m_41720_() == MKBItems.SEAGRASS_STICK.get() && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                        level.m_245747_(blockPos, (SoundEvent)MKBSounds.CORAL_MUSH_BLOCK_BREATHE.get(), SoundSource.BLOCKS, 1.0f, 0.6f, true);
                        CoralMushBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)MKBItems.CORAL_STAR.get()));
                        level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                        return InteractionResult.SUCCESS;
                    }
                    Optional<CoralTransformRecipe> optional = coralMushBlockEntity.getRecipe(stack);
                    if (optional.isPresent()) {
                        coralMushBlockEntity.addItem((Entity)player, player.m_150110_().f_35937_ ? stack.m_41777_() : stack, optional.get().getTransformTime());
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                CoralMushBlock.m_152435_((Level)level, (BlockPos)blockPos, (Direction)Direction.UP, (ItemStack)coralMushBlockEntity.popItem());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return CoralMushBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)MKBBlockEntityTypes.CORAL_MUSH_BLOCK_ENTITY.get()), CoralMushBlockEntity::transformTick);
        }
        return CoralMushBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)MKBBlockEntityTypes.CORAL_MUSH_BLOCK_ENTITY.get()), CoralMushBlockEntity::particleTick);
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new CoralMushBlockEntity(blockPos, state);
    }
}

