/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.data.recipes.CountingTags;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.util.FloatemStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FloatemTagStack {
    Set<ResourceLocation> tags;
    final ItemStack stack;
    float count;

    public FloatemTagStack(FloatemStack stack) {
        FoodValueRecipe fvr = FoodValueRecipe.recipes.get(stack.getItem());
        this.tags = fvr == null ? stack.getTags().filter(CountingTags.tags::contains).collect(Collectors.toSet()) : fvr.getTags();
        this.stack = stack.stack;
        this.count = stack.count;
    }

    public FloatemTagStack(ItemStack stack) {
        FoodValueRecipe fvr = FoodValueRecipe.recipes.get(stack.m_41720_());
        this.tags = fvr == null ? stack.m_204131_().map(TagKey::f_203868_).filter(CountingTags.tags::contains).collect(Collectors.toSet()) : fvr.getTags();
        this.stack = stack;
        this.count = stack.m_41613_();
    }

    public Set<ResourceLocation> getTags() {
        return this.tags;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getCount() {
        return this.count;
    }

    public static Map<ResourceLocation, Float> calculateTypes(Stream<FloatemTagStack> stacks) {
        HashMap<ResourceLocation, Float> map = new HashMap<ResourceLocation, Float>();
        stacks.forEach(e -> {
            float c = e.count;
            for (ResourceLocation tag : e.tags) {
                map.merge(tag, Float.valueOf(c), Float::sum);
            }
        });
        return map;
    }

    public Item getItem() {
        return this.stack.m_41720_();
    }
}

