/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.util.TabType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CreativeTabItemHelper
implements CreativeModeTab.Output {
    private CreativeModeTab tab;
    private ResourceKey<CreativeModeTab> key;
    private int num = Integer.MIN_VALUE;
    private List<Entry> items = new ArrayList<Entry>();

    public CreativeModeTab getTab() {
        return this.tab;
    }

    public CreativeTabItemHelper(ResourceKey<CreativeModeTab> key, CreativeModeTab tab) {
        this.key = key;
        this.tab = tab;
    }

    public boolean isMainTab() {
        return TabType.MAIN.test(this.key);
    }

    public boolean isFoodTab() {
        return TabType.FOODS.test(this.key);
    }

    public boolean isType(TabType tab) {
        if (tab == null) {
            return false;
        }
        return tab.test(this.key);
    }

    public void register(CreativeModeTab.Output event) {
        this.items.sort(Comparator.comparingInt(Entry::getSortnum).thenComparing(Entry::getInsnum));
        for (Entry e : this.items) {
            event.m_246267_(e.is, e.tab);
        }
    }

    public void m_246267_(ItemStack stack, CreativeModeTab.TabVisibility visibility) {
        this.accept(stack, 0, visibility);
    }

    public void accept(Supplier<? extends ItemLike> item, CreativeModeTab.TabVisibility visibility) {
        this.m_245282_(item.get(), visibility);
    }

    public void accept(Supplier<? extends ItemLike> item) {
        this.m_246326_(item.get());
    }

    public void accept(ItemStack pStack, int sortNum, CreativeModeTab.TabVisibility pTabVisibility) {
        this.items.add(new Entry(pStack, pTabVisibility, sortNum, this.num++));
    }

    public void accept(ItemStack pStack, int sortNum) {
        this.accept(pStack, sortNum, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void accept(ItemLike pItem, int sortNum, CreativeModeTab.TabVisibility pTabVisibility) {
        this.accept(new ItemStack(pItem), sortNum, pTabVisibility);
    }

    public void accept(ItemLike pItem, int sortNum) {
        this.accept(new ItemStack(pItem), sortNum, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void acceptAll(Collection<ItemStack> pStacks, int sortNum, CreativeModeTab.TabVisibility pTabVisibility) {
        pStacks.forEach(p_252337_ -> this.accept((ItemStack)p_252337_, sortNum, pTabVisibility));
    }

    public void acceptAll(Collection<ItemStack> pStacks, int sortNum) {
        this.acceptAll(pStacks, sortNum, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static class Entry {
        public ItemStack is;
        public CreativeModeTab.TabVisibility tab;
        int sortnum;
        int insnum;

        public Entry(ItemStack is, CreativeModeTab.TabVisibility tab, int sortnum, int insnum) {
            this.is = is;
            this.tab = tab;
            this.sortnum = sortnum;
            this.insnum = insnum;
        }

        public int getSortnum() {
            return this.sortnum;
        }

        public int getInsnum() {
            return this.insnum;
        }
    }
}

