/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.patchouli;

import com.teammoeg.caupona.api.GameTranslation;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

@OnlyIn(value=Dist.CLIENT)
public class AllowenceTooltip
implements ICustomComponent {
    boolean allow;
    int x;
    int y;
    int w;
    int h;
    IVariable recipe;
    transient List<Component> allowence;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipe = (IVariable)lookup.apply(this.recipe);
        ResourceLocation out = new ResourceLocation(this.recipe.asString());
        Recipe r = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(out).orElse(null);
        if (r instanceof IConditionalRecipe) {
            IConditionalRecipe cr = (IConditionalRecipe)r;
            List<IngredientCondition> conds = this.allow ? cr.getAllow() : cr.getDeny();
            if (conds != null) {
                this.allowence = conds.stream().map(e -> e.getTranslation(GameTranslation.get())).map(Utils::string).collect(Collectors.toList());
            }
            if (this.allowence != null && !this.allowence.isEmpty()) {
                if (this.allow) {
                    this.allowence.add(0, (Component)Utils.translate("recipe.caupona.allow"));
                } else {
                    this.allowence.add(0, (Component)Utils.translate("recipe.caupona.deny"));
                }
            }
        }
    }

    public void build(int componentX, int componentY, int pageNum) {
    }

    public void render(GuiGraphics ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        if (context.isAreaHovered(mouseX, mouseY, this.x, this.y, this.w, this.h) && this.allowence != null && !this.allowence.isEmpty()) {
            context.setHoverTooltipComponents(this.allowence);
        }
    }
}

