/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IConditionalRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.data.recipes.StewPendingContext;
import com.teammoeg.caupona.data.recipes.baseconditions.BaseConditions;
import com.teammoeg.caupona.data.recipes.conditions.Conditions;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.util.FloatemTagStack;
import com.teammoeg.caupona.util.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class StewCookingRecipe
extends IDataRecipe
implements IConditionalRecipe {
    public static Set<CookIngredients> cookables;
    public static Set<Fluid> allOutput;
    public static List<StewCookingRecipe> sorted;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    List<IngredientCondition> allow;
    List<IngredientCondition> deny;
    int priority = 0;
    public int time;
    float density;
    List<StewBaseCondition> base;
    public Fluid output;
    public boolean removeNBT = false;

    public static boolean isCookable(ItemStack stack) {
        FloatemTagStack s = new FloatemTagStack(stack);
        return stack.m_204117_(CPTags.Items.COOKABLE) || cookables.stream().anyMatch(e -> e.fits(s));
    }

    public static boolean isBoilable(FluidStack f) {
        Fluid fd = f.getFluid();
        return fd instanceof SoupFluid || f.getFluid().m_205067_(CPTags.Fluids.BOILABLE);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public StewCookingRecipe(ResourceLocation id) {
        super(id);
    }

    public StewCookingRecipe(ResourceLocation id, JsonObject data) {
        super(id);
        if (data.has("allow")) {
            this.allow = SerializeUtil.parseJsonList(data.get("allow"), Conditions::of);
            Conditions.checkConditions(this.allow);
        }
        if (data.has("deny")) {
            this.deny = SerializeUtil.parseJsonList(data.get("deny"), Conditions::of);
            Conditions.checkConditions(this.deny);
        }
        if (data.has("priority")) {
            this.priority = data.get("priority").getAsInt();
        }
        if (data.has("density")) {
            this.density = data.get("density").getAsFloat();
        }
        this.time = data.get("time").getAsInt();
        if (data.has("base")) {
            this.base = SerializeUtil.parseJsonList(data.get("base"), BaseConditions::of);
        }
        this.output = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(data.get("output").getAsString()));
        if (this.output == Fluids.f_76191_) {
            throw new InvalidRecipeException();
        }
        if (data.has("removeNBT")) {
            this.removeNBT = data.get("removeNBT").getAsBoolean();
        }
    }

    public StewCookingRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.allow = SerializeUtil.readList(data, Conditions::of);
        this.deny = SerializeUtil.readList(data, Conditions::of);
        this.priority = data.m_130242_();
        this.density = data.readFloat();
        this.time = data.m_130242_();
        this.base = SerializeUtil.readList(data, BaseConditions::of);
        this.output = (Fluid)data.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.removeNBT = data.readBoolean();
    }

    public StewCookingRecipe(ResourceLocation id, List<IngredientCondition> allow, List<IngredientCondition> deny, int priority, int time, float density, List<StewBaseCondition> base, Fluid output, boolean removeNBT) {
        super(id);
        this.allow = allow;
        this.deny = deny;
        this.priority = priority;
        this.time = time;
        this.density = density;
        this.base = base;
        this.output = output;
        this.removeNBT = removeNBT;
    }

    public void write(FriendlyByteBuf data) {
        SerializeUtil.writeList(data, this.allow, Conditions::write);
        SerializeUtil.writeList(data, this.deny, Conditions::write);
        data.m_130130_(this.priority);
        data.writeFloat(this.density);
        data.m_130130_(this.time);
        SerializeUtil.writeList(data, this.base, BaseConditions::write);
        data.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.output);
        data.writeBoolean(this.removeNBT);
    }

    public int matches(StewPendingContext ctx) {
        if (ctx.getTotalItems() < this.density) {
            return 0;
        }
        int matchtype = 0;
        if (this.base != null) {
            StewBaseCondition e;
            Iterator<StewBaseCondition> iterator = this.base.iterator();
            while (iterator.hasNext() && (matchtype = ctx.compute(e = iterator.next())) == 0) {
            }
            if (matchtype == 0) {
                return 0;
            }
        }
        if (matchtype == 0) {
            matchtype = 1;
        }
        if (this.allow != null) {
            if (!this.allow.stream().allMatch(ctx::compute)) {
                return 0;
            }
        }
        if (this.deny != null) {
            if (this.deny.stream().anyMatch(ctx::compute)) {
                return 0;
            }
        }
        return matchtype;
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        if (this.allow != null && !this.allow.isEmpty()) {
            json.add("allow", (JsonElement)SerializeUtil.toJsonList(this.allow, IngredientCondition::serialize));
        }
        if (this.deny != null && !this.deny.isEmpty()) {
            json.add("deny", (JsonElement)SerializeUtil.toJsonList(this.deny, IngredientCondition::serialize));
        }
        if (this.priority != 0) {
            json.addProperty("priority", (Number)this.priority);
        }
        json.addProperty("density", (Number)Float.valueOf(this.density));
        json.addProperty("time", (Number)this.time);
        if (this.base != null && !this.base.isEmpty()) {
            json.add("base", (JsonElement)SerializeUtil.toJsonList(this.base, StewBaseCondition::serialize));
        }
        json.addProperty("output", Utils.getRegistryName(this.output).toString());
        if (this.removeNBT) {
            json.addProperty("removeNBT", Boolean.valueOf(this.removeNBT));
        }
    }

    public Stream<CookIngredients> getAllNumbers() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getAllNumbers), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getAllNumbers));
    }

    public Stream<ResourceLocation> getTags() {
        return Stream.concat(this.allow == null ? Stream.empty() : this.allow.stream().flatMap(IngredientCondition::getTags), this.deny == null ? Stream.empty() : this.deny.stream().flatMap(IngredientCondition::getTags));
    }

    public int getPriority() {
        return this.priority;
    }

    public List<StewBaseCondition> getBase() {
        return this.base;
    }

    @Override
    public List<IngredientCondition> getAllow() {
        return this.allow;
    }

    @Override
    public List<IngredientCondition> getDeny() {
        return this.deny;
    }

    public float getDensity() {
        return this.density;
    }
}

