/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddPoolLootModifier
extends LootModifier {
    public static final Codec<AddPoolLootModifier> CODEC = RecordCodecBuilder.create(inst -> AddPoolLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(lm -> lm.lootTable)).apply((Applicative)inst, AddPoolLootModifier::new));
    ResourceLocation lootTable;

    protected AddPoolLootModifier(LootItemCondition[] conditionsIn, ResourceLocation table) {
        super(conditionsIn);
        this.lootTable = table;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootTable lt = context.m_278643_().m_278676_(this.lootTable);
        lt.m_79131_(new LootContext.Builder(context).withQueriedLootTableId(this.lootTable).m_287259_(null), arg_0 -> generatedLoot.add(arg_0));
        return generatedLoot;
    }

    public static Builder builder(ResourceLocation table) {
        return new Builder(table);
    }

    public static class Builder {
        List<LootItemCondition> cond = new ArrayList<LootItemCondition>();
        ResourceLocation table;

        Builder(ResourceLocation table) {
            this.table = table;
        }

        public Builder when(LootItemCondition.Builder builder) {
            this.cond.add(builder.m_6409_());
            return this;
        }

        public AddPoolLootModifier build() {
            return new AddPoolLootModifier((LootItemCondition[])this.cond.toArray(LootItemCondition[]::new), this.table);
        }
    }
}

