/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.compat.jei.category.IConditionalCategory;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class StewCookingCategory
extends IConditionalCategory<StewCookingRecipe> {
    public static RecipeType<StewCookingRecipe> TYPE = RecipeType.create((String)"caupona", (String)"stew_cooking", StewCookingRecipe.class);
    private IDrawable ICON;
    private IGuiHelper helper;

    public StewCookingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.anyWater.get()));
        this.helper = guiHelper;
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.stew_cooking.title");
    }

    @Override
    public void drawCustom(StewCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        IDrawable density = (double)recipe.getDensity() < 0.4 ? DENSITY[0] : ((double)recipe.getDensity() < 0.6 ? DENSITY[1] : ((double)recipe.getDensity() < 0.8 ? DENSITY[2] : ((double)recipe.getDensity() < 1.2 ? DENSITY[3] : DENSITY[4])));
        density.draw(stack, 25, 15);
    }

    @Override
    public void draw(StewCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ResourceLocation imagePath = new ResourceLocation(recipe.m_6423_().m_135827_(), "textures/gui/recipes/" + recipe.m_6423_().m_135815_() + ".png");
        if (Minecraft.m_91087_().m_91098_().m_213713_(imagePath).isPresent()) {
            PoseStack mstack = stack.m_280168_();
            mstack.m_85836_();
            mstack.m_85841_(0.5f, 0.5f, 0.0f);
            this.helper.createDrawable(imagePath, 0, 0, 200, 210).draw(stack);
            mstack.m_85849_();
        } else {
            super.draw(recipe, recipeSlotsView, stack, mouseX, mouseY);
        }
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StewCookingRecipe recipe, IFocusGroup focuses) {
        if (recipe.getBase() != null && recipe.getBase().size() > 0) {
            ArrayList<FluidStack> fss = new ArrayList<FluidStack>();
            for (Fluid f : ForgeRegistries.FLUIDS) {
                for (StewBaseCondition base : recipe.getBase()) {
                    if (!base.test(f)) continue;
                    fss.add(new FluidStack(f, 250));
                }
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 13).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fss)).setFluidRenderer(250L, false, 16, 16);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 30, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPItems.any.get()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 18).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.output, 250))).setFluidRenderer(250L, false, 16, 16);
    }

    @Override
    public List<Component> getTooltipStrings(StewCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (StewCookingCategory.inRange(mouseX, mouseY, 21, 6, 34, 30)) {
            return Arrays.asList(Utils.translate("recipe.caupona.density", Float.valueOf(recipe.getDensity())));
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    public RecipeType<StewCookingRecipe> getRecipeType() {
        return TYPE;
    }

    @Override
    public IDrawable getHeadings() {
        return POT_HEADING;
    }
}

