/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.client.util.DisplayGroupProperty;
import com.teammoeg.caupona.client.util.DynamicBlockModelReference;
import com.teammoeg.caupona.client.util.DynamicRenderLevel;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ModelUtils {
    public static void renderQuads(List<BakedQuad> quads, VertexConsumer renderer, PoseStack transform, int color, int light, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (color >= 0) {
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        }
        for (BakedQuad quad : quads) {
            renderer.m_85987_(transform.m_85850_(), quad, red, green, blue, light, overlay);
        }
    }

    public static void tesellate(BlockEntity be, BlockState bs, BakedModel model, VertexConsumer renderer, PoseStack transform, int overlay, ModelData data) {
        Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)be.m_58904_(), model, bs, be.m_58899_(), transform, renderer, true, DynamicBlockModelReference.getRandomSource(), 42L, overlay, data, null);
    }

    public static void tesellateRotatable(BlockEntity be, Direction.Axis rot, BlockState bs, BakedModel model, VertexConsumer renderer, PoseStack transform, int overlay, ModelData data) {
        Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)new DynamicRenderLevel(be.m_58904_(), be.m_58899_(), rot), model, bs, be.m_58899_(), transform, renderer, true, DynamicBlockModelReference.getRandomSource(), 42L, overlay, data, null);
    }

    public static void tesellate(BlockEntity be, DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int overlay, ModelData data) {
        ModelUtils.tesellate(be, be.m_58900_(), model.get(), renderer, transform, overlay, data);
    }

    public static void tesellateRotatable(BlockEntity be, Direction.Axis rot, DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int overlay, ModelData data) {
        ModelUtils.tesellateRotatable(be, rot, be.m_58900_(), model.get(), renderer, transform, overlay, data);
    }

    public static void tesellateRotatableModel(BlockEntity be, Direction.Axis rot, DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int overlay) {
        ModelUtils.tesellateRotatable(be, rot, model, renderer, transform, overlay, ModelData.EMPTY);
    }

    public static void tesellateRotatableModelGroups(BlockEntity be, Direction.Axis rot, DynamicBlockModelReference model, VertexConsumer renderer, ImmutableSet<String> groups, PoseStack transform, int overlay) {
        ModelUtils.tesellateRotatable(be, rot, model, renderer, transform, overlay, ModelData.builder().with((ModelProperty)DisplayGroupProperty.PROPERTY, groups).build());
    }

    public static void tesellateModel(BlockEntity be, DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int overlay) {
        ModelUtils.tesellate(be, model, renderer, transform, overlay, ModelData.EMPTY);
    }

    public static void tesellateModelGroups(BlockEntity be, DynamicBlockModelReference model, VertexConsumer renderer, ImmutableSet<String> groups, PoseStack transform, int overlay) {
        ModelUtils.tesellate(be, model, renderer, transform, overlay, ModelData.builder().with((ModelProperty)DisplayGroupProperty.PROPERTY, groups).build());
    }

    public static DynamicBlockModelReference getModel(String name) {
        return new DynamicBlockModelReference(name);
    }

    public static DynamicBlockModelReference getModel(String modid, String name) {
        return new DynamicBlockModelReference(new ResourceLocation(modid, "block/dynamic/" + name));
    }

    public static void renderModelGroups(DynamicBlockModelReference model, VertexConsumer renderer, ImmutableSet<String> groups, PoseStack transform, int color, int light, int overlay) {
        ModelUtils.renderQuads(model.apply(ModelData.builder().with((ModelProperty)DisplayGroupProperty.PROPERTY, groups).build()), renderer, transform, color, light, overlay);
    }

    public static void renderModel(DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int color, int light, int overlay) {
        ModelUtils.renderQuads(model.getAllQuads(), renderer, transform, color, light, overlay);
    }

    public static void renderModelGroups(DynamicBlockModelReference model, VertexConsumer renderer, ImmutableSet<String> groups, PoseStack transform, int light, int overlay) {
        ModelUtils.renderModelGroups(model, renderer, groups, transform, -1, light, overlay);
    }

    public static void renderModel(DynamicBlockModelReference model, VertexConsumer renderer, PoseStack transform, int light, int overlay) {
        ModelUtils.renderModel(model, renderer, transform, -1, light, overlay);
    }
}

