/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import com.teammoeg.caupona.client.util.LayeredBakedModel;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class LayeredElementsModel
implements IUnbakedGeometry<LayeredElementsModel> {
    private final Map<String, BlockElement> elements;
    private final Map<String, Set<Integer>> groups;

    public LayeredElementsModel(Map<String, BlockElement> elements, Map<String, Set<Integer>> groups) {
        this.elements = elements;
        this.groups = groups;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        try {
            TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
            ResourceLocation renderTypeHint = context.getRenderTypeHint();
            RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
            LayeredBakedModel.Builder builder = new LayeredBakedModel.Builder(context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), context.getTransforms(), overrides).particle(particle);
            this.addQuads(context, builder, baker, spriteGetter, modelState, modelLocation);
            return builder.build(renderTypes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void addQuads(IGeometryBakingContext context, LayeredBakedModel.Builder builder, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
        IQuadTransformer postTransform = context.getRootTransform().isIdentity() ? QuadTransformers.empty() : QuadTransformers.applying((Transformation)modelState.m_6189_().m_121096_(context.getRootTransform()).m_121096_(modelState.m_6189_().m_121103_()));
        int no = 0;
        for (BlockElement element : this.elements.values()) {
            HashSet<String> groupNames = new HashSet<String>();
            groupNames.add("root");
            for (Map.Entry<String, Set<Integer>> i : this.groups.entrySet()) {
                if (!i.getValue().contains(no)) continue;
                groupNames.add(i.getKey());
            }
            for (Direction direction : element.f_111310_.keySet()) {
                BlockElementFace face = (BlockElementFace)element.f_111310_.get(direction);
                TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.f_111356_));
                BakedQuad quad = BlockModel.m_111437_((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState, (ResourceLocation)modelLocation);
                postTransform.processInPlace(quad);
                builder.addUnculledFace(quad, groupNames);
            }
            ++no;
        }
    }

    public static final class Loader
    implements IGeometryLoader<LayeredElementsModel> {
        public static Set<Integer> loadGroup(JsonArray je, String prefix, Map<String, Set<Integer>> result) {
            HashSet<Integer> set = new HashSet<Integer>();
            int i = 0;
            for (JsonElement group : je) {
                if (group.isJsonObject()) {
                    Object name = "group_" + i++;
                    JsonObject g = group.getAsJsonObject();
                    name = GsonHelper.m_13851_((JsonObject)g, (String)"name", (String)name);
                    Set<Integer> crnset = Loader.loadGroup(GsonHelper.m_13933_((JsonObject)g, (String)"children"), prefix + (String)name + ".", result);
                    set.addAll(crnset);
                    result.put(prefix + (String)name, crnset);
                    continue;
                }
                set.add(group.getAsInt());
            }
            return set;
        }

        public LayeredElementsModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            if (!jsonObject.has("elements")) {
                throw new JsonParseException("An element model must have an \"elements\" member.");
            }
            LinkedHashMap<String, BlockElement> elements = new LinkedHashMap<String, BlockElement>();
            LinkedHashMap<String, Set<Integer>> groups = new LinkedHashMap<String, Set<Integer>>();
            int i = 0;
            if (jsonObject.has("groups")) {
                Loader.loadGroup(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"groups"), "", groups);
            }
            i = 0;
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"elements")) {
                Object name = "layer_" + i++;
                if (element.isJsonObject()) {
                    name = GsonHelper.m_13851_((JsonObject)element.getAsJsonObject(), (String)"name", (String)name);
                }
                elements.put((String)name, (BlockElement)deserializationContext.deserialize(element, BlockElement.class));
            }
            return new LayeredElementsModel(elements, groups);
        }
    }
}

