/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pot;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.pot.StewPotContainer;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.DissolveRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.data.recipes.StewPendingContext;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.SyncedFluidHandler;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class StewPotBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable {
    private ItemStackHandler inv = new ItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 9) {
                return stack.m_41720_() == Items.f_42589_ && !PotionUtils.m_43547_((ItemStack)stack).stream().anyMatch(t -> t.m_19557_() == 1) || StewCookingRecipe.isCookable(stack);
            }
            if (slot == 9) {
                Item i = stack.m_41720_();
                return i == Items.f_42399_ || Utils.getFluidType(stack) != Fluids.f_76191_ || AspicMeltingRecipe.find(stack) != null;
            }
            if (slot == 11) {
                return SpiceRecipe.isValid(stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot < 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    public StewInfo current;
    private FluidTank tank = new FluidTank(1250, StewCookingRecipe::isBoilable){

        protected void onContentsChanged() {
            if (this.isEmpty()) {
                StewPotBlockEntity.this.current = null;
            }
            StewPotBlockEntity.this.still.rewind();
        }
    };
    public int process;
    public int processMax;
    public LazyTickWorker still;
    public LazyTickWorker contain;
    public boolean working = false;
    public boolean operate = false;
    public short proctype = 0;
    public boolean rsstate = false;
    boolean isInfinite = false;
    public Fluid become;
    public ResourceLocation nextbase;
    boolean removesNBT = false;
    public static final short NOP = 0;
    public static final short BOILING = 1;
    public static final short COOKING = 2;
    public static final short STIRING = 3;
    IFluidHandler handler = new SyncedFluidHandler(this, new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int t) {
            if (t == 0) {
                return StewPotBlockEntity.this.tank.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int t) {
            if (t == 0) {
                return StewPotBlockEntity.this.tank.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int t, FluidStack stack) {
            if (t == 0 && StewPotBlockEntity.this.canAddFluid()) {
                return StewPotBlockEntity.this.tank.isFluidValid(stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid() && !StewPotBlockEntity.this.isInfinite) {
                return StewPotBlockEntity.this.tank.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid()) {
                if (StewPotBlockEntity.this.isInfinite) {
                    return action.simulate() ? resource : StewPotBlockEntity.this.tryAddSpice(resource);
                }
                return action.simulate() ? StewPotBlockEntity.this.tank.drain(resource, action) : StewPotBlockEntity.this.tryAddSpice(StewPotBlockEntity.this.tank.drain(resource, action));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (StewPotBlockEntity.this.canAddFluid()) {
                if (StewPotBlockEntity.this.isInfinite) {
                    return action.simulate() ? new FluidStack(StewPotBlockEntity.this.tank.getFluid(), maxDrain) : StewPotBlockEntity.this.tryAddSpice(new FluidStack(StewPotBlockEntity.this.tank.getFluid(), maxDrain));
                }
                return action.simulate() ? StewPotBlockEntity.this.tank.drain(maxDrain, action) : StewPotBlockEntity.this.tryAddSpice(StewPotBlockEntity.this.tank.drain(maxDrain, action));
            }
            return FluidStack.EMPTY;
        }
    });
    public IItemHandler bowl = new IItemHandler(){

        public int getSlots() {
            return StewPotBlockEntity.this.inv.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return StewPotBlockEntity.this.inv.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 9 || slot == 10) {
                return stack;
            }
            return StewPotBlockEntity.this.inv.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 9 || slot == 11) {
                return ItemStack.f_41583_;
            }
            if (slot < 9 && StewPotBlockEntity.this.inv.isItemValid(slot, StewPotBlockEntity.this.inv.getStackInSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return StewPotBlockEntity.this.inv.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return StewPotBlockEntity.this.inv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 9 || slot == 10) {
                return false;
            }
            return StewPotBlockEntity.this.inv.isItemValid(slot, stack);
        }
    };
    RangedWrapper ingredient = new RangedWrapper((IItemHandlerModifiable)this.inv, 0, 10){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    LazyOptional<IItemHandler> up = LazyOptional.of(() -> this.ingredient);
    LazyOptional<IItemHandler> side = LazyOptional.of(() -> this.bowl);
    LazyOptional<IFluidHandler> fl = LazyOptional.of(() -> this.handler);

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public StewPotBlockEntity(BlockPos p, BlockState s) {
        super((BlockEntityType)CPBlockEntityTypes.STEW_POT.get(), p, s);
        this.still = new LazyTickWorker((Integer)CPConfig.COMMON.staticTime.get(), () -> {
            DoliumRecipe recipe;
            if (this.inv.getStackInSlot(10).m_41619_() && (recipe = DoliumRecipe.testPot(this.getTank().getFluid())) != null) {
                ItemStack out = recipe.handle(this.getTank().getFluid());
                this.inv.setStackInSlot(10, out);
            }
            return true;
        });
        this.contain = new LazyTickWorker((Integer)CPConfig.SERVER.containerTick.get(), () -> {
            if (this.isInfinite) {
                FluidStack fs = new FluidStack(this.tank.getFluid(), this.tank.getFluidAmount());
                if (this.canAddFluid()) {
                    this.tryContianFluid();
                }
                this.tank.setFluid(fs);
            } else if (this.canAddFluid() && this.tryContianFluid()) {
                return true;
            }
            return false;
        });
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void resetResult() {
        this.become = null;
        this.nextbase = null;
        this.removesNBT = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tick() {
        boolean syncNeeded = false;
        if (this.f_58857_.f_46443_) return;
        this.working = false;
        if (this.processMax > 0) {
            this.still.rewind();
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (!(blockEntity instanceof IStove)) return;
            IStove stove = (IStove)blockEntity;
            int rh = stove.requestHeat();
            if (!this.isInfinite) {
                this.process += rh;
                if (rh > 0) {
                    syncNeeded = true;
                }
            }
            if (rh > 0) {
                this.working = true;
            }
            if (this.process >= this.processMax) {
                this.process = 0;
                this.processMax = 0;
                this.doWork();
                syncNeeded = true;
            }
        } else {
            if (!this.tank.isEmpty() && !this.isInfinite) {
                syncNeeded |= this.still.tick();
            }
            if (!this.isInfinite && this.proctype <= 1) {
                this.prepareWork();
                if (this.proctype != 0) {
                    syncNeeded = true;
                }
            }
            syncNeeded |= this.contain.tick();
        }
        if (!syncNeeded) return;
        this.syncData();
    }

    private FluidStack tryAddSpice(FluidStack fs) {
        ItemStack ospi;
        SpiceRecipe spice = null;
        ItemStack spi = ospi = this.inv.getStackInSlot(11);
        if (fs.getAmount() % 250 == 0 && fs.getFluid() instanceof SoupFluid) {
            spice = SpiceRecipe.find(spi);
        }
        StewInfo si = null;
        if (this.m_58900_().m_60713_((Block)CPBlocks.STEW_POT_LEAD.get())) {
            if (spice == null) {
                si = SoupFluid.getInfo(fs);
                if (si.getDensity() > 1.5f) {
                    spi = CPItems.getSapa();
                    spice = SpiceRecipe.find(spi);
                }
            } else if (spice.canReactLead) {
                spi = CPItems.getSapa();
                spice = SpiceRecipe.find(spi);
            }
        }
        if (spice != null) {
            if (si == null) {
                si = SoupFluid.getInfo(fs);
            }
            if (!si.canAddSpice()) {
                return fs;
            }
            if (!this.isInfinite) {
                int consume = fs.getAmount() / 250;
                if (SpiceRecipe.getMaxUse(spi) < consume) {
                    return fs;
                }
                this.inv.setStackInSlot(11, SpiceRecipe.handle(ospi, consume));
            }
            si.addSpice(spice.effect, spi);
            SoupFluid.setInfo(fs, si);
        }
        return fs;
    }

    private boolean tryContianFluid() {
        ItemStack is = this.inv.getStackInSlot(9);
        if (!is.m_41619_() && this.inv.getStackInSlot(10).m_41619_()) {
            AspicMeltingRecipe amr;
            BowlContainingRecipe recipe;
            if (is.m_41720_() == Items.f_42399_ && this.tank.getFluidAmount() >= 250 && (recipe = BowlContainingRecipe.recipes.get(this.tank.getFluid().getFluid())) != null) {
                is.m_41774_(1);
                this.inv.setStackInSlot(10, recipe.handle(this.tryAddSpice(this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE))));
                this.still.rewind();
                return true;
            }
            FluidStack out = Utils.extractFluid(is);
            if (!out.isEmpty()) {
                if (this.tryAddFluid(out)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    is.m_41774_(1);
                    this.still.rewind();
                    this.inv.setStackInSlot(10, ret);
                    return true;
                }
                return false;
            }
            if (!this.isInfinite && (amr = AspicMeltingRecipe.find(is)) != null) {
                int remainSpace = this.tank.getCapacity() - this.tank.getFluidAmount();
                int produce = Math.min(remainSpace / amr.amount, is.m_41613_());
                FluidStack fs = amr.handle(is);
                fs.setAmount(fs.getAmount() * produce);
                if (this.tryAddFluid(fs, amr.time, false)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    ret.m_41764_(produce);
                    is.m_41774_(produce);
                    this.still.rewind();
                    this.inv.setStackInSlot(10, ret);
                    return true;
                }
                return false;
            }
            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true);
            if (far.isSuccess()) {
                is.m_41774_(1);
                if (far.getResult() != null) {
                    this.still.rewind();
                    this.inv.setStackInSlot(10, far.getResult());
                }
            }
        }
        return false;
    }

    public boolean canAddFluid() {
        return this.proctype == 0;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.process = nbt.m_128451_("process");
        this.processMax = nbt.m_128451_("processMax");
        this.proctype = nbt.m_128448_("worktype");
        this.rsstate = nbt.m_128471_("rsstate");
        if (this.inv.getSlots() < 12) {
            this.inv.setSize(12);
        }
        if (isClient) {
            this.working = nbt.m_128471_("working");
        }
        this.tank.readFromNBT(nbt);
        this.become = nbt.m_128441_("result") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("result"))) : null;
        this.isInfinite = nbt.m_128471_("inf");
        if (!isClient) {
            this.inv.deserializeNBT(nbt.m_128469_("inv"));
            this.current = nbt.m_128441_("current") ? new StewInfo(nbt.m_128469_("current")) : null;
            this.nextbase = nbt.m_128441_("resultBase") ? new ResourceLocation(nbt.m_128461_("resultBase")) : null;
            this.still.read(nbt, "nowork");
            this.removesNBT = nbt.m_128471_("removeNbt");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128405_("process", this.process);
        nbt.m_128405_("processMax", this.processMax);
        nbt.m_128376_("worktype", this.proctype);
        nbt.m_128379_("rsstate", this.rsstate);
        if (isClient) {
            nbt.m_128379_("working", this.working);
        }
        this.tank.writeToNBT(nbt);
        if (this.become != null) {
            nbt.m_128359_("result", Utils.getRegistryName(this.become).toString());
        }
        nbt.m_128379_("inf", this.isInfinite);
        if (!isClient) {
            nbt.m_128365_("inv", (Tag)this.inv.serializeNBT());
            this.still.write(nbt, "nowork");
            if (this.current != null) {
                nbt.m_128365_("current", (Tag)this.current.save());
            }
            if (this.nextbase != null) {
                nbt.m_128359_("resultBase", this.nextbase.toString());
            }
            nbt.m_128379_("removeNbt", this.removesNBT);
        }
    }

    private void prepareWork() {
        if (this.rsstate && this.proctype == 0 && !this.operate && this.f_58857_.m_276867_(this.f_58858_)) {
            this.operate = true;
        }
        if (this.operate && this.proctype == 0) {
            IStove stove;
            this.operate = false;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
                return;
            }
            if (this.doBoil()) {
                this.proctype = 1;
            } else if (this.makeSoup()) {
                this.proctype = (short)2;
            }
        } else if (this.proctype == 1) {
            if (this.makeSoup()) {
                this.proctype = (short)2;
            } else {
                this.proctype = 0;
                this.syncData();
            }
        }
    }

    private void doWork() {
        if (this.proctype == 1) {
            this.finishBoil();
            boolean hasItem = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack is = this.inv.getStackInSlot(i);
                if (is.m_41619_()) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) {
                this.proctype = 0;
            }
        } else if (this.proctype == 2 || this.proctype == 3) {
            this.finishSoup();
        }
    }

    private boolean doBoil() {
        BoilingRecipe recipe = BoilingRecipe.recipes.get(this.tank.getFluid().getFluid());
        if (recipe == null) {
            return false;
        }
        this.become = recipe.after;
        this.processMax = (int)((float)recipe.time * ((float)this.tank.getFluidAmount() / 250.0f));
        this.process = 0;
        return true;
    }

    private void finishBoil() {
        BoilingRecipe recipe = BoilingRecipe.recipes.get(this.tank.getFluid().getFluid());
        if (recipe == null) {
            return;
        }
        this.current = null;
        this.tank.setFluid(recipe.handle(this.tank.getFluid()));
    }

    private void adjustParts(int count) {
        float oparts = (float)this.tank.getFluidAmount() / 250.0f;
        int parts = (int)(oparts + (float)count);
        this.getCurrent().adjustParts(oparts, parts);
        this.tank.getFluid().setAmount(parts * 250);
    }

    private boolean makeSoup() {
        ItemStack is;
        if (this.tank.getFluidAmount() <= 250) {
            return false;
        }
        if (this.getCurrent().stacks.size() > 27) {
            return false;
        }
        int oparts = this.tank.getFluidAmount() / 250;
        int parts = oparts - 1;
        int itms = 0;
        ArrayList<MobEffectInstance> cr = new ArrayList<MobEffectInstance>(this.current.effects);
        for (int i = 0; i < 9; ++i) {
            ItemStack is2 = this.inv.getStackInSlot(i);
            if (is2.m_41619_()) continue;
            if (is2.m_41720_() == Items.f_42589_) {
                block1: for (MobEffectInstance n : PotionUtils.m_43547_((ItemStack)is2)) {
                    for (MobEffectInstance eff : cr) {
                        if (!StewInfo.isEffectEquals(eff, n)) continue;
                        continue block1;
                    }
                    cr.add(n);
                }
                continue;
            }
            if (StewCookingRecipe.isCookable(is2)) {
                ++itms;
                continue;
            }
            return false;
        }
        if ((float)itms / (float)parts + this.current.getDensity() * (float)oparts / (float)parts > 3.0f || cr.size() > 3) {
            return false;
        }
        this.process = 0;
        this.adjustParts(-1);
        boolean hasItem = false;
        NonNullList interninv = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 9; ++i) {
            ItemStack is3 = this.inv.getStackInSlot(i);
            if (is3.m_41619_()) continue;
            if (is3.m_41720_() == Items.f_42589_) {
                for (MobEffectInstance eff : PotionUtils.m_43547_((ItemStack)is3)) {
                    this.current.addEffect(eff, parts);
                }
                this.inv.setStackInSlot(i, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                for (int j = 0; j < 9; ++j) {
                    ItemStack ois = (ItemStack)interninv.get(j);
                    if (ois.m_41619_()) {
                        interninv.set(j, (Object)is3.m_41777_());
                        break;
                    }
                    if (!ItemStack.m_150942_((ItemStack)ois, (ItemStack)is3)) continue;
                    ois.m_41764_(ois.m_41613_() + is3.m_41613_());
                    break;
                }
                this.inv.setStackInSlot(i, is3.getCraftingRemainingItem());
            }
            hasItem = true;
        }
        if (!hasItem) {
            this.current.completeEffects();
            this.processMax = Math.max((Integer)CPConfig.SERVER.potCookTimeBase.get(), this.decideSoup());
            return true;
        }
        int tpt = (Integer)CPConfig.SERVER.potMixTimeBase.get();
        block6: for (int i = 0; i < 9 && !(is = (ItemStack)interninv.get(i)).m_41619_(); ++i) {
            this.current.addItem(is, parts);
            for (DissolveRecipe rs : DissolveRecipe.recipes) {
                if (!rs.item.test(is)) continue;
                tpt += rs.time;
                continue block6;
            }
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(is.m_41720_());
            if (fvr == null) continue;
            tpt += fvr.processtimes.getOrDefault(is.m_41720_(), 0).intValue();
        }
        this.current.completeAll();
        tpt = Math.max((Integer)CPConfig.SERVER.potCookTimeBase.get(), tpt);
        interninv.clear();
        this.processMax = Math.max(this.decideSoup(), tpt);
        return true;
    }

    private int decideSoup() {
        this.become = this.tank.getFluid().getFluid();
        StewPendingContext ctx = new StewPendingContext(this.getCurrent(), Utils.getRegistryName(this.become));
        this.nextbase = this.current.base;
        if (ctx.getItems().isEmpty()) {
            return 0;
        }
        for (StewCookingRecipe cr : StewCookingRecipe.sorted) {
            int mt = cr.matches(ctx);
            if (mt == 0) continue;
            this.nextbase = mt == 2 ? Utils.getRegistryName(this.become) : this.current.base;
            this.become = cr.output;
            this.removesNBT = cr.removeNBT;
            return cr.time;
        }
        return 0;
    }

    private void finishSoup() {
        if (this.nextbase != null && this.become != null) {
            FluidStack fss = new FluidStack(this.become, this.tank.getFluidAmount());
            if (!this.removesNBT) {
                if (!this.getCurrent().base.equals((Object)this.nextbase)) {
                    this.current.shrinkedFluid = 0.0f;
                }
                this.current.base = this.nextbase;
                this.current.recalculateHAS();
                SoupFluid.setInfo(fss, this.current);
            }
            this.tank.setFluid(fss);
        }
        this.resetResult();
        this.proctype = 0;
    }

    public boolean canAddFluid(FluidStack fs) {
        IStove stove;
        if (this.isInfinite) {
            return false;
        }
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            return tryfill == fs.getAmount();
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
            return false;
        }
        StewInfo n = SoupFluid.getInfo(fs);
        if (!(this.getCurrent().base.equals((Object)n.base) || this.current.base.equals((Object)Utils.getRegistryName(fs)) || n.base.equals((Object)Utils.getRegistryName(this.tank.getFluid())))) {
            BoilingRecipe bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (!this.current.base.equals((Object)Utils.getRegistryName(bnx.after))) {
                return false;
            }
        }
        return this.current.canMerge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f);
    }

    public boolean tryAddFluid(FluidStack fs) {
        return this.tryAddFluid(fs, (Integer)CPConfig.SERVER.potMixTimeBase.get(), true);
    }

    public boolean tryAddFluid(FluidStack fs, int extraTime, boolean canIgnoreHeat) {
        IStove stove;
        int tryfill;
        if (this.isInfinite) {
            return false;
        }
        if (canIgnoreHeat) {
            tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
            if (tryfill > 0) {
                if (tryfill == fs.getAmount()) {
                    this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    this.still.rewind();
                    return true;
                }
                return false;
            }
        } else if (this.tank.isEmpty() && (tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (tryfill == fs.getAmount()) {
                this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                this.proctype = (short)3;
                this.process = 0;
                this.processMax = extraTime;
                this.resetResult();
                this.still.rewind();
                return true;
            }
            return false;
        }
        if (this.tank.getCapacity() - this.tank.getFluidAmount() < fs.getAmount()) {
            return false;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
            return false;
        }
        StewInfo n = SoupFluid.getInfo(fs);
        int pm = 0;
        if (!(this.getCurrent().base.equals((Object)n.base) || this.current.base.equals((Object)Utils.getRegistryName(fs)) || n.base.equals((Object)Utils.getRegistryName(this.tank.getFluid())))) {
            BoilingRecipe bnx = BoilingRecipe.recipes.get(fs.getFluid());
            if (bnx == null) {
                return false;
            }
            if (!this.getCurrent().base.equals((Object)Utils.getRegistryName(bnx.after))) {
                return false;
            }
            fs = bnx.handle(fs);
            pm = (int)((float)bnx.time * ((float)fs.getAmount() / 250.0f));
        }
        if (this.current.merge(n, (float)this.tank.getFluidAmount() / 250.0f, (float)fs.getAmount() / 250.0f)) {
            this.adjustParts(fs.getAmount() / 250);
            int num = Math.max(this.decideSoup(), extraTime);
            this.proctype = (short)3;
            this.process = 0;
            this.processMax = Math.max(pm, num);
            this.still.rewind();
            return true;
        }
        return false;
    }

    public AbstractContainerMenu m_7208_(int p1, Inventory p2, Player p3) {
        return new StewPotContainer(p1, p2, this);
    }

    public Component m_5446_() {
        return Utils.translate("container.caupona.stewpot.title");
    }

    @Override
    public void handleMessage(short type, int data) {
        if (type == 0 && this.proctype == 0) {
            this.operate = true;
        }
        if (type == 1) {
            if (data == 1) {
                this.rsstate = false;
            } else if (data == 2) {
                this.rsstate = true;
            }
        }
        this.syncData();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.up.cast();
            }
            return this.side.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fl.cast();
        }
        return super.getCapability(cap, side);
    }

    public StewInfo getCurrent() {
        if (this.current == null) {
            this.current = SoupFluid.getInfo(this.tank.getFluid());
        }
        return this.current;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }
}

