/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.dolium;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.blocks.dolium.DoliumContainer;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.SyncedFluidHandler;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CounterDoliumBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable {
    ItemStackHandler inv = new ItemStackHandler(6){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 3) {
                return DoliumRecipe.testInput(stack);
            }
            if (slot == 3) {
                return SpiceRecipe.isValid(stack);
            }
            return slot == 4;
        }
    };
    public final FluidTank tank = new FluidTank(1250, f -> !f.getFluid().getFluidType().isLighterThanAir()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CounterDoliumBlockEntity.this.process = -1;
        }
    };
    public int process;
    public int processMax;
    public LazyTickWorker contain;
    boolean isInfinite = false;
    ItemStack inner = ItemStack.f_41583_;
    RangedWrapper bowl = new RangedWrapper((IItemHandlerModifiable)this.inv, 3, 6){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 5) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 3 || slot == 4) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    RangedWrapper ingredient = new RangedWrapper((IItemHandlerModifiable)this.inv, 0, 3){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    IFluidHandler handler = new SyncedFluidHandler(this, new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int t) {
            if (t == 0) {
                return CounterDoliumBlockEntity.this.tank.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int t) {
            if (t == 0) {
                return CounterDoliumBlockEntity.this.tank.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int t, FluidStack stack) {
            return CounterDoliumBlockEntity.this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (!CounterDoliumBlockEntity.this.isInfinite) {
                return CounterDoliumBlockEntity.this.tank.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (CounterDoliumBlockEntity.this.isInfinite) {
                return action.simulate() ? resource : CounterDoliumBlockEntity.this.tryAddSpice(resource);
            }
            return action.simulate() ? CounterDoliumBlockEntity.this.tank.drain(resource, action) : CounterDoliumBlockEntity.this.tryAddSpice(CounterDoliumBlockEntity.this.tank.drain(resource, action));
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (CounterDoliumBlockEntity.this.isInfinite) {
                return action.simulate() ? new FluidStack(CounterDoliumBlockEntity.this.tank.getFluid(), maxDrain) : CounterDoliumBlockEntity.this.tryAddSpice(new FluidStack(CounterDoliumBlockEntity.this.tank.getFluid(), maxDrain));
            }
            return action.simulate() ? CounterDoliumBlockEntity.this.tank.drain(maxDrain, action) : CounterDoliumBlockEntity.this.tryAddSpice(CounterDoliumBlockEntity.this.tank.drain(maxDrain, action));
        }
    });
    LazyOptional<IItemHandler> up = LazyOptional.of(() -> this.ingredient);
    LazyOptional<IItemHandler> side = LazyOptional.of(() -> this.bowl);
    LazyOptional<IFluidHandler> fl = LazyOptional.of(() -> this.handler);

    private FluidStack tryAddSpice(FluidStack fs) {
        SpiceRecipe spice = null;
        ItemStack spi = this.inv.getStackInSlot(3);
        if (fs.getAmount() % 250 == 0 && fs.getFluid() instanceof SoupFluid) {
            spice = SpiceRecipe.find(spi);
        }
        if (spice != null) {
            StewInfo si = SoupFluid.getInfo(fs);
            if (!si.canAddSpice()) {
                return fs;
            }
            if (!this.isInfinite) {
                int consume = fs.getAmount() / 250;
                if (SpiceRecipe.getMaxUse(spi) < consume) {
                    return fs;
                }
                this.inv.setStackInSlot(3, SpiceRecipe.handle(spi, consume));
            }
            si.addSpice(spice.effect, spi);
            SoupFluid.setInfo(fs, si);
        }
        return fs;
    }

    public CounterDoliumBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.DOLIUM.get(), pWorldPosition, pBlockState);
        this.processMax = (Integer)CPConfig.COMMON.staticTime.get();
        this.contain = new LazyTickWorker((Integer)CPConfig.SERVER.containerTick.get(), () -> {
            if (this.isInfinite) {
                FluidStack fs = new FluidStack(this.tank.getFluid(), this.tank.getFluidAmount());
                this.tryContianFluid();
                this.tank.setFluid(fs);
            } else if (this.tryContianFluid()) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.process = nbt.m_128451_("process");
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.isInfinite = nbt.m_128471_("inf");
        if (!isClient) {
            this.inner = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("inner"));
            this.inv.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128405_("process", this.process);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128379_("inf", this.isInfinite);
        if (!isClient) {
            nbt.m_128365_("inventory", (Tag)this.inv.serializeNBT());
            nbt.m_128365_("inner", (Tag)this.inner.serializeNBT());
        }
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.inner.m_41619_()) {
            this.inner = Utils.insertToOutput(this.inv, 5, this.inner);
            this.m_6596_();
            return;
        }
        boolean updateNeeded = this.contain.tick();
        if (!(this.process >= 0 && this.process % 20 != 0 || this.isInfinite)) {
            if (DoliumRecipe.testDolium(this.tank.getFluid(), this.inv) != null) {
                if (this.process == -1) {
                    this.process = 0;
                    updateNeeded = true;
                }
            } else if (this.process != -1) {
                this.process = -1;
                updateNeeded = true;
            }
        }
        if (this.process >= 0 && !this.isInfinite) {
            ++this.process;
            if (this.process >= this.processMax) {
                DoliumRecipe recipe;
                this.process = -1;
                if (this.inner.m_41619_() && (recipe = DoliumRecipe.testDolium(this.tank.getFluid(), this.inv)) != null) {
                    this.inner = recipe.handleDolium(this.tank.getFluid(), this.inv);
                }
            }
            updateNeeded = true;
        }
        if (updateNeeded) {
            this.syncData();
        }
    }

    boolean tryAddFluid(FluidStack fs) {
        if (this.isInfinite) {
            return false;
        }
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            if (tryfill == fs.getAmount()) {
                this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                this.process = -1;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean tryContianFluid() {
        ItemStack is = this.inv.getStackInSlot(4);
        if (!is.m_41619_() && this.inv.getStackInSlot(5).m_41619_()) {
            BowlContainingRecipe recipe;
            if (is.m_41720_() == Items.f_42399_ && this.tank.getFluidAmount() >= 250 && (recipe = BowlContainingRecipe.recipes.get(this.tank.getFluid().getFluid())) != null) {
                is.m_41774_(1);
                this.inv.setStackInSlot(5, recipe.handle(this.tryAddSpice(this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE))));
                this.process = -1;
                return true;
            }
            FluidStack out = Utils.extractFluid(is);
            if (!out.isEmpty()) {
                if (this.tryAddFluid(out)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    is.m_41774_(1);
                    this.process = -1;
                    this.inv.setStackInSlot(5, ret);
                }
                return true;
            }
            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true);
            if (far.isSuccess()) {
                is.m_41774_(1);
                if (far.getResult() != null) {
                    this.process = -1;
                    this.inv.setStackInSlot(5, far.getResult());
                }
                return true;
            }
            if (!this.isInfinite && (far = FluidUtil.tryEmptyContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true)).isSuccess()) {
                is.m_41774_(1);
                if (far.getResult() != null) {
                    this.process = -1;
                    this.inv.setStackInSlot(5, far.getResult());
                }
                return true;
            }
        }
        return false;
    }

    public AbstractContainerMenu m_7208_(int p1, Inventory p2, Player p3) {
        return new DoliumContainer(p1, p2, this);
    }

    public Component m_5446_() {
        return Utils.translate("container.caupona.counter_dolium.title");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.up.cast();
            }
            return this.side.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fl.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }
}

