/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.api;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.IFoodInfo;
import com.teammoeg.caupona.util.SauteedFoodInfo;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauponaApi {
    private CauponaApi() {
    }

    public static StewInfo getStewInfo(ItemStack item) {
        return StewItem.getInfo(item);
    }

    public static StewInfo getStewInfo(FluidStack item) {
        return SoupFluid.getInfo(item);
    }

    public static StewInfo getStewInfo(CompoundTag nbt) {
        return new StewInfo(nbt);
    }

    public static SauteedFoodInfo getSauteedInfo(ItemStack item) {
        return DishItem.getInfo(item);
    }

    public static SauteedFoodInfo getSauteedInfo(CompoundTag nbt) {
        return new SauteedFoodInfo(nbt);
    }

    public static void setInfo(ItemStack item, StewInfo info) {
        StewItem.setInfo(item, info);
    }

    public static void setInfo(FluidStack item, StewInfo info) {
        SoupFluid.setInfo(item, info);
    }

    public static void setInfo(CompoundTag nbt, StewInfo info) {
        info.write(nbt);
    }

    public static void setInfo(ItemStack item, SauteedFoodInfo info) {
        DishItem.setInfo(item, info);
    }

    public static void setInfo(CompoundTag nbt, SauteedFoodInfo info) {
        info.write(nbt);
    }

    public static void apply(Level worldIn, LivingEntity entityLiving, IFoodInfo info) {
        if (!worldIn.f_46443_) {
            RandomSource r = entityLiving.m_217043_();
            for (Pair<Supplier<MobEffectInstance>, Float> ef : info.getEffects()) {
                if (!(r.m_188501_() < ((Float)ef.getSecond()).floatValue())) continue;
                entityLiving.m_7292_((MobEffectInstance)((Supplier)ef.getFirst()).get());
            }
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.m_36324_().m_38707_(info.getHealing(), info.getSaturation());
            }
        }
    }

    public static Optional<ItemStack> fillBowl(IFluidHandler handler) {
        FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (stack.getAmount() == 250) {
            return CauponaApi.fillBowl(handler.drain(250, IFluidHandler.FluidAction.EXECUTE));
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getFilledItemStack(IFluidHandler handler, ItemStack in) {
        FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        ContanerContainFoodEvent ev = Utils.contain(in, stack, true);
        if (ev.isAllowed()) {
            return CauponaApi.getFilledItemStack(handler.drain(ev.drainAmount, IFluidHandler.FluidAction.EXECUTE), in);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getFilledItemStack(FluidStack stack, ItemStack in) {
        ContanerContainFoodEvent ev = Utils.contain(in, stack, false);
        if (ev.isAllowed()) {
            return Optional.of(ev.out);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> fillBowl(FluidStack stack) {
        if (stack.getAmount() != 250) {
            return Optional.empty();
        }
        BowlContainingRecipe recipe = BowlContainingRecipe.recipes.get(stack.getFluid());
        if (recipe != null) {
            ItemStack ret = recipe.handle(stack);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getBlockFilledItemStack(Fluid f, ItemStack is) {
        FluidStack stack = new FluidStack(f, 250);
        ContanerContainFoodEvent ev = Utils.containBlock(is, stack);
        if (ev.isAllowed()) {
            return Optional.of(ev.out);
        }
        return Optional.empty();
    }
}

