/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.google.common.collect.Lists;
import com.mojang.authlib.minecraft.report.AbuseReport;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.authlib.minecraft.report.ReportChatMessage;
import com.mojang.authlib.minecraft.report.ReportEvidence;
import com.mojang.authlib.minecraft.report.ReportedEntity;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.client.multiplayer.chat.ChatLog;
import net.minecraft.client.multiplayer.chat.LoggedChatMessage;
import net.minecraft.client.multiplayer.chat.report.ChatReportContextBuilder;
import net.minecraft.client.multiplayer.chat.report.ReportReason;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import org.apache.commons.lang3.StringUtils;

public class ChatReportBuilder {
    private final ChatReport f_252499_;
    private final AbuseReportLimits f_238736_;

    public ChatReportBuilder(ChatReport p_254092_, AbuseReportLimits p_254265_) {
        this.f_252499_ = p_254092_;
        this.f_238736_ = p_254265_;
    }

    public ChatReportBuilder(UUID p_239528_, AbuseReportLimits p_239529_) {
        this.f_252499_ = new ChatReport(UUID.randomUUID(), Instant.now(), p_239528_);
        this.f_238736_ = p_239529_;
    }

    public ChatReport m_253002_() {
        return this.f_252499_;
    }

    public UUID m_239436_() {
        return this.f_252499_.f_252536_;
    }

    public IntSet m_239716_() {
        return this.f_252499_.f_252475_;
    }

    public String m_238976_() {
        return this.f_252499_.f_252421_;
    }

    public void m_239079_(String p_239080_) {
        this.f_252499_.f_252421_ = p_239080_;
    }

    @Nullable
    public ReportReason m_239339_() {
        return this.f_252499_.f_252479_;
    }

    public void m_239097_(ReportReason p_239098_) {
        this.f_252499_.f_252479_ = p_239098_;
    }

    public void m_239051_(int p_239052_) {
        this.f_252499_.m_252761_(p_239052_, this.f_238736_);
    }

    public boolean m_240221_(int p_243333_) {
        return this.f_252499_.f_252475_.contains(p_243333_);
    }

    public boolean m_252870_() {
        return StringUtils.isNotEmpty((CharSequence)this.m_238976_()) || !this.m_239716_().isEmpty() || this.m_239339_() != null;
    }

    @Nullable
    public CannotBuildReason m_239332_() {
        if (this.f_252499_.f_252475_.isEmpty()) {
            return CannotBuildReason.f_238619_;
        }
        if (this.f_252499_.f_252475_.size() > this.f_238736_.maxReportedMessageCount()) {
            return CannotBuildReason.f_238799_;
        }
        if (this.f_252499_.f_252479_ == null) {
            return CannotBuildReason.f_238819_;
        }
        if (this.f_252499_.f_252421_.length() > this.f_238736_.maxOpinionCommentsLength()) {
            return CannotBuildReason.f_238583_;
        }
        return null;
    }

    public Either<Result, CannotBuildReason> m_240128_(ReportingContext p_240129_) {
        CannotBuildReason $$1 = this.m_239332_();
        if ($$1 != null) {
            return Either.right((Object)$$1);
        }
        String $$2 = Objects.requireNonNull(this.f_252499_.f_252479_).m_239892_();
        ReportEvidence $$3 = this.m_239182_(p_240129_.m_239899_());
        ReportedEntity $$4 = new ReportedEntity(this.f_252499_.f_252536_);
        AbuseReport $$5 = new AbuseReport(this.f_252499_.f_252421_, $$2, $$3, $$4, this.f_252499_.f_252413_);
        return Either.left((Object)new Result(this.f_252499_.f_252481_, $$5));
    }

    private ReportEvidence m_239182_(ChatLog p_239183_) {
        ArrayList $$1 = new ArrayList();
        ChatReportContextBuilder $$2 = new ChatReportContextBuilder(this.f_238736_.leadingContextMessageCount());
        $$2.m_246644_(p_239183_, (IntCollection)this.f_252499_.f_252475_, (p_247891_, p_247892_) -> $$1.add(this.m_246289_(p_247892_, this.m_240221_(p_247891_))));
        return new ReportEvidence(Lists.reverse($$1));
    }

    private ReportChatMessage m_246289_(LoggedChatMessage.Player p_251321_, boolean p_252182_) {
        SignedMessageLink $$2 = p_251321_.f_241690_().f_243882_();
        SignedMessageBody $$3 = p_251321_.f_241690_().f_240885_();
        List<ByteBuffer> $$4 = $$3.f_240868_().f_241630_().stream().map(MessageSignature::m_241929_).toList();
        ByteBuffer $$5 = Optionull.m_269382_(p_251321_.f_241690_().f_244279_(), MessageSignature::m_241929_);
        return new ReportChatMessage($$2.f_244066_(), $$2.f_244443_(), $$2.f_244370_(), $$3.f_240863_(), $$3.f_240873_(), $$4, $$3.f_240856_(), $$5, p_252182_);
    }

    public ChatReportBuilder m_239582_() {
        return new ChatReportBuilder(this.f_252499_.m_252798_(), this.f_238736_);
    }

    public class ChatReport {
        final UUID f_252481_;
        final Instant f_252413_;
        final UUID f_252536_;
        final IntSet f_252475_ = new IntOpenHashSet();
        String f_252421_ = "";
        @Nullable
        ReportReason f_252479_;

        ChatReport(UUID p_254298_, Instant p_253854_, UUID p_253630_) {
            this.f_252481_ = p_254298_;
            this.f_252413_ = p_253854_;
            this.f_252536_ = p_253630_;
        }

        public void m_252761_(int p_254375_, AbuseReportLimits p_254456_) {
            if (this.f_252475_.contains(p_254375_)) {
                this.f_252475_.remove(p_254375_);
            } else if (this.f_252475_.size() < p_254456_.maxReportedMessageCount()) {
                this.f_252475_.add(p_254375_);
            }
        }

        public ChatReport m_252798_() {
            ChatReport $$0 = new ChatReport(this.f_252481_, this.f_252413_, this.f_252536_);
            $$0.f_252475_.addAll((IntCollection)this.f_252475_);
            $$0.f_252421_ = this.f_252421_;
            $$0.f_252479_ = this.f_252479_;
            return $$0;
        }

        public boolean m_252787_(UUID p_253762_) {
            return p_253762_.equals(this.f_252536_);
        }
    }

    public record CannotBuildReason(Component f_238631_) {
        public static final CannotBuildReason f_238819_ = new CannotBuildReason(Component.m_237115_("gui.chatReport.send.no_reason"));
        public static final CannotBuildReason f_238619_ = new CannotBuildReason(Component.m_237115_("gui.chatReport.send.no_reported_messages"));
        public static final CannotBuildReason f_238799_ = new CannotBuildReason(Component.m_237115_("gui.chatReport.send.too_many_messages"));
        public static final CannotBuildReason f_238583_ = new CannotBuildReason(Component.m_237115_("gui.chatReport.send.comments_too_long"));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CannotBuildReason.class, "message", "f_238631_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CannotBuildReason.class, "message", "f_238631_"}, this);
        }

        @Override
        public final boolean equals(Object p_240127_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CannotBuildReason.class, "message", "f_238631_"}, this, p_240127_);
        }
    }

    public record Result(UUID f_238815_, AbuseReport f_238727_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Result.class, "id;report", "f_238815_", "f_238727_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Result.class, "id;report", "f_238815_", "f_238727_"}, this);
        }

        @Override
        public final boolean equals(Object p_238996_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Result.class, "id;report", "f_238815_", "f_238727_"}, this, p_238996_);
        }
    }
}

