/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import org.slf4j.Logger;

public class BitmapProvider
implements GlyphProvider {
    static final Logger f_95328_ = LogUtils.getLogger();
    private final NativeImage f_95329_;
    private final CodepointMap<Glyph> f_95330_;

    BitmapProvider(NativeImage p_285380_, CodepointMap<Glyph> p_285445_) {
        this.f_95329_ = p_285380_;
        this.f_95330_ = p_285445_;
    }

    @Override
    public void close() {
        this.f_95329_.close();
    }

    @Override
    @Nullable
    public GlyphInfo m_214022_(int p_232638_) {
        return this.f_95330_.m_284412_(p_232638_);
    }

    @Override
    public IntSet m_6990_() {
        return IntSets.unmodifiable((IntSet)this.f_95330_.m_284498_());
    }

    record Glyph(float f_95363_, NativeImage f_95364_, int f_95365_, int f_95366_, int f_95367_, int f_95368_, int f_95369_, int f_95370_) implements GlyphInfo
    {
        @Override
        public float m_7403_() {
            return this.f_95369_;
        }

        @Override
        public BakedGlyph m_213604_(Function<SheetGlyphInfo, BakedGlyph> p_232640_) {
            return p_232640_.apply(new SheetGlyphInfo(){

                @Override
                public float m_213963_() {
                    return 1.0f / f_95363_;
                }

                @Override
                public int m_213962_() {
                    return f_95367_;
                }

                @Override
                public int m_213961_() {
                    return f_95368_;
                }

                @Override
                public float m_213964_() {
                    return SheetGlyphInfo.super.m_213964_() + 7.0f - (float)f_95370_;
                }

                @Override
                public void m_213958_(int p_232658_, int p_232659_) {
                    f_95364_.m_85003_(0, p_232658_, p_232659_, f_95365_, f_95366_, f_95367_, f_95368_, false, false);
                }

                @Override
                public boolean m_213965_() {
                    return f_95364_.m_85102_().m_85161_() > 1;
                }
            });
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Glyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "f_95363_", "f_95364_", "f_95365_", "f_95366_", "f_95367_", "f_95368_", "f_95369_", "f_95370_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Glyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "f_95363_", "f_95364_", "f_95365_", "f_95366_", "f_95367_", "f_95368_", "f_95369_", "f_95370_"}, this);
        }

        @Override
        public final boolean equals(Object p_232645_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Glyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "f_95363_", "f_95364_", "f_95365_", "f_95366_", "f_95367_", "f_95368_", "f_95369_", "f_95370_"}, this, p_232645_);
        }
    }

    public record Definition(ResourceLocation f_285631_, int f_285660_, int f_285577_, int[][] f_285611_) implements GlyphProviderDefinition
    {
        private static final Codec<int[][]> f_285599_ = ExtraCodecs.m_264370_(Codec.STRING.listOf().xmap(p_286900_ -> {
            int $$1 = p_286900_.size();
            int[][] $$2 = new int[$$1][];
            for (int $$3 = 0; $$3 < $$1; ++$$3) {
                $$2[$$3] = ((String)p_286900_.get($$3)).codePoints().toArray();
            }
            return $$2;
        }, p_286828_ -> {
            ArrayList<String> $$1 = new ArrayList<String>(((int[][])p_286828_).length);
            for (int[] $$2 : p_286828_) {
                $$1.add(new String($$2, 0, $$2.length));
            }
            return $$1;
        }), Definition::m_285860_);
        public static final MapCodec<Definition> f_285606_ = ExtraCodecs.m_285994_(RecordCodecBuilder.mapCodec(p_286905_ -> p_286905_.group((App)ResourceLocation.f_135803_.fieldOf("file").forGetter(Definition::f_285631_), (App)Codec.INT.optionalFieldOf("height", (Object)8).forGetter(Definition::f_285660_), (App)Codec.INT.fieldOf("ascent").forGetter(Definition::f_285577_), (App)f_285599_.fieldOf("chars").forGetter(Definition::f_285611_)).apply((Applicative)p_286905_, Definition::new)), Definition::m_285746_);

        private static DataResult<int[][]> m_285860_(int[][] p_286348_) {
            int $$1 = p_286348_.length;
            if ($$1 == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            int[] $$2 = p_286348_[0];
            int $$3 = $$2.length;
            if ($$3 == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            for (int $$4 = 1; $$4 < $$1; ++$$4) {
                int[] $$5 = p_286348_[$$4];
                if ($$5.length == $$3) continue;
                return DataResult.error(() -> "Lines in codepoint grid have to be the same length (found: " + $$5.length + " codepoints, expected: " + $$3 + "), pad with \\u0000");
            }
            return DataResult.success((Object)p_286348_);
        }

        private static DataResult<Definition> m_285746_(Definition p_286662_) {
            if (p_286662_.f_285577_ > p_286662_.f_285660_) {
                return DataResult.error(() -> "Ascent " + p_286688_.f_285577_ + " higher than height " + p_286688_.f_285660_);
            }
            return DataResult.success((Object)p_286662_);
        }

        @Override
        public GlyphProviderType m_285843_() {
            return GlyphProviderType.BITMAP;
        }

        @Override
        public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> m_285782_() {
            return Either.left(this::m_286048_);
        }

        private GlyphProvider m_286048_(ResourceManager p_286694_) throws IOException {
            ResourceLocation $$1 = this.f_285631_.m_246208_("textures/");
            try (InputStream $$2 = p_286694_.m_215595_($$1);){
                NativeImage $$3 = NativeImage.m_85048_(NativeImage.Format.RGBA, $$2);
                int $$4 = $$3.m_84982_();
                int $$5 = $$3.m_85084_();
                int $$6 = $$4 / this.f_285611_[0].length;
                int $$7 = $$5 / this.f_285611_.length;
                float $$8 = (float)this.f_285660_ / (float)$$7;
                CodepointMap<Glyph> $$9 = new CodepointMap<Glyph>(Glyph[]::new, p_286759_ -> new Glyph[p_286759_][]);
                for (int $$10 = 0; $$10 < this.f_285611_.length; ++$$10) {
                    int $$11 = 0;
                    for (int $$12 : this.f_285611_[$$10]) {
                        int $$14;
                        Glyph $$15;
                        int $$13 = $$11++;
                        if ($$12 == 0 || ($$15 = $$9.m_284506_($$12, new Glyph($$8, $$3, $$13 * $$6, $$10 * $$7, $$6, $$7, (int)(0.5 + (double)((float)($$14 = this.m_285979_($$3, $$6, $$7, $$13, $$10)) * $$8)) + 1, this.f_285577_))) == null) continue;
                        f_95328_.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString($$12), (Object)$$1);
                    }
                }
                BitmapProvider bitmapProvider = new BitmapProvider($$3, $$9);
                return bitmapProvider;
            }
        }

        private int m_285979_(NativeImage p_286449_, int p_286656_, int p_286554_, int p_286657_, int p_286307_) {
            int $$5;
            for ($$5 = p_286656_ - 1; $$5 >= 0; --$$5) {
                int $$6 = p_286657_ * p_286656_ + $$5;
                for (int $$7 = 0; $$7 < p_286554_; ++$$7) {
                    int $$8 = p_286307_ * p_286554_ + $$7;
                    if (p_286449_.m_85087_($$6, $$8) == 0) continue;
                    return $$5 + 1;
                }
            }
            return $$5 + 1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Definition.class, "file;height;ascent;codepointGrid", "f_285631_", "f_285660_", "f_285577_", "f_285611_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Definition.class, "file;height;ascent;codepointGrid", "f_285631_", "f_285660_", "f_285577_", "f_285611_"}, this);
        }

        @Override
        public final boolean equals(Object p_286334_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Definition.class, "file;height;ascent;codepointGrid", "f_285631_", "f_285660_", "f_285577_", "f_285611_"}, this, p_286334_);
        }
    }
}

