/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.util;

import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Tentacle_Entity;
import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TidalTentacleUtil {
    private static final String LAST_TENTACLE_UUID = "LastTidalTentacleUUIDCataclysm";
    private static final String LAST_TENTACLE_ID = "LastTidalTentacleIDCataclysm";

    private static void sync(LivingEntity enchanted, CompoundTag tag) {
        CitadelEntityData.setCitadelTag((LivingEntity)enchanted, (CompoundTag)tag);
        if (!enchanted.m_9236_().f_46443_) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CataclysmTagUpdate", tag, enchanted.m_19879_()));
        } else {
            Citadel.sendMSGToServer((Object)new PropertiesMessage("CataclysmTagUpdate", tag, enchanted.m_19879_()));
        }
    }

    public static void setLastTentacle(LivingEntity entity, Tidal_Tentacle_Entity tendon) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tendon == null) {
            tag.m_128473_(LAST_TENTACLE_UUID);
            tag.m_128405_(LAST_TENTACLE_ID, -1);
        } else {
            tag.m_128362_(LAST_TENTACLE_UUID, tendon.m_20148_());
            tag.m_128405_(LAST_TENTACLE_ID, tendon.m_19879_());
        }
        TidalTentacleUtil.sync(entity, tag);
    }

    private static UUID getLastTentacleUUID(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.m_128441_(LAST_TENTACLE_UUID)) {
            return tag.m_128342_(LAST_TENTACLE_UUID);
        }
        return null;
    }

    public static int getLastTentacleId(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.m_128441_(LAST_TENTACLE_ID)) {
            return tag.m_128451_(LAST_TENTACLE_ID);
        }
        return -1;
    }

    public static void retractFarTentacles(Level level, LivingEntity livingEntity) {
        Tidal_Tentacle_Entity last = TidalTentacleUtil.getLastTendon(livingEntity);
        if (last != null) {
            last.m_142687_(Entity.RemovalReason.DISCARDED);
            TidalTentacleUtil.setLastTentacle(livingEntity, null);
        }
    }

    public static boolean canLaunchTentacles(Level level, LivingEntity livingEntity) {
        Tidal_Tentacle_Entity last = TidalTentacleUtil.getLastTendon(livingEntity);
        if (last != null) {
            return last.m_213877_();
        }
        return true;
    }

    public static Tidal_Tentacle_Entity getLastTendon(LivingEntity livingEntity) {
        UUID uuid = TidalTentacleUtil.getLastTentacleUUID(livingEntity);
        int id = TidalTentacleUtil.getLastTentacleId(livingEntity);
        if (!livingEntity.m_9236_().f_46443_) {
            if (uuid != null) {
                Entity e = livingEntity.m_9236_().m_6815_(id);
                return e instanceof Tidal_Tentacle_Entity ? (Tidal_Tentacle_Entity)e : null;
            }
        } else if (id != -1) {
            Entity e = livingEntity.m_9236_().m_6815_(id);
            return e instanceof Tidal_Tentacle_Entity ? (Tidal_Tentacle_Entity)e : null;
        }
        return null;
    }
}

