/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.crafting;

import com.github.alexthe666.citadel.client.model.container.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Type;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class AltarOfAmethystRecipe {
    private final NonNullList<Ingredient> ingredients;
    private ItemStack result = ItemStack.f_41583_;
    private int time = 0;

    public AltarOfAmethystRecipe(NonNullList<Ingredient> ingredients, ItemStack result, int time) {
        this.result = result;
        this.ingredients = ingredients;
        this.time = time;
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public int getTime() {
        return this.time;
    }

    public boolean matches(ItemStack ... stacks) {
        IntArrayList taken = new IntArrayList();
        ItemStack[] copy = new ItemStack[stacks.length];
        for (int j = 0; j < copy.length; ++j) {
            copy[j] = stacks[j].m_41777_();
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (!((Ingredient)this.ingredients.get(i)).test(copy[j])) continue;
                taken.add(j);
                copy[j].m_41774_(1);
            }
        }
        return taken.size() >= this.ingredients.size();
    }

    public static class Deserializer
    implements JsonDeserializer<AltarOfAmethystRecipe> {
        public AltarOfAmethystRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            int time = JsonUtils.getInt((JsonObject)jsonobject, (String)"time");
            ItemStack result = ItemStack.f_41583_;
            if (jsonobject.has("result")) {
                result = ShapedRecipe.m_151274_((JsonObject)JsonUtils.getJsonObject((JsonObject)jsonobject, (String)"result"));
            }
            NonNullList<Ingredient> nonnulllist = AltarOfAmethystRecipe.readIngredients(JsonUtils.getJsonArray((JsonObject)jsonobject, (String)"ingredients"));
            return new AltarOfAmethystRecipe(nonnulllist, result, time);
        }
    }
}

