/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.client.gui.FoodBookScreen;
import com.cazsius.solcarrot.client.gui.elements.ImageData;
import com.cazsius.solcarrot.client.gui.elements.UIBox;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.client.gui.elements.UILabel;
import com.cazsius.solcarrot.client.gui.elements.UIStack;
import com.cazsius.solcarrot.lib.Localization;
import java.awt.Rectangle;

abstract class Page
extends UIElement {
    final UIStack mainStack = new UIStack();
    final int spacing = 6;

    Page(Rectangle frame, String header) {
        super(frame);
        this.mainStack.axis = UIStack.Axis.VERTICAL;
        this.mainStack.spacing = 6;
        UILabel headerLabel = new UILabel(header);
        this.mainStack.addChild(headerLabel);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.children.add(this.mainStack);
        this.updateMainStack();
    }

    void updateMainStack() {
        this.mainStack.setCenterX(this.getCenterX());
        this.mainStack.setMinY(this.getMinY() + 17);
        this.mainStack.updateFrames();
    }

    String fraction(int numerator, int denominator) {
        return Localization.localized("gui", "food_book.fraction", numerator, denominator);
    }

    UIElement makeSeparatorLine() {
        return UIBox.horizontalLine(0, this.getWidth() / 2, 0, FoodBookScreen.leastBlack);
    }

    UIElement statWithIcon(ImageData icon, String value, String name) {
        UIStack valueStack = new UIStack();
        valueStack.axis = UIStack.Axis.HORIZONTAL;
        valueStack.spacing = 3;
        valueStack.addChild(new UIImage(icon));
        valueStack.addChild(new UILabel(value));
        UIStack fullStack = new UIStack();
        fullStack.axis = UIStack.Axis.VERTICAL;
        fullStack.spacing = 2;
        fullStack.addChild(valueStack);
        UILabel nameLabel = new UILabel(name);
        nameLabel.color = FoodBookScreen.lessBlack;
        fullStack.addChild(nameLabel);
        return fullStack;
    }
}

