/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.util.nbt;

import dev.xkmc.l2library.util.nbt.ItemListTag;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemCompoundTag {
    private final ItemStack stack;
    private final Supplier<CompoundTag> creator;
    private final Consumer<CompoundTag> replacer;
    @Nullable
    private CompoundTag tag;

    public static ItemCompoundTag of(ItemStack stack) {
        return new ItemCompoundTag(stack, () -> ((ItemStack)stack).m_41784_(), arg_0 -> ((ItemStack)stack).m_41751_(arg_0), stack.m_41783_());
    }

    ItemCompoundTag(ItemStack root, Supplier<CompoundTag> creator, Consumer<CompoundTag> replacer, @Nullable CompoundTag tag) {
        this.stack = root;
        this.creator = creator;
        this.replacer = replacer;
        this.tag = tag;
    }

    public ItemStack getHolderStack() {
        return this.stack;
    }

    public boolean isPresent() {
        return this.tag != null;
    }

    public CompoundTag getOrCreate() {
        if (this.tag == null) {
            this.tag = this.creator.get();
        }
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
        this.replacer.accept(tag);
    }

    public ItemCompoundTag getSubTag(String key) {
        CompoundTag sub = null;
        if (this.tag != null && this.tag.m_128425_(key, 10)) {
            sub = this.tag.m_128469_(key);
        }
        return new ItemCompoundTag(this.stack, () -> {
            CompoundTag self = this.getOrCreate();
            CompoundTag next = self.m_128469_(key);
            if (!self.m_128441_(key)) {
                self.m_128365_(key, (Tag)next);
            }
            return next;
        }, newTag -> {
            CompoundTag self = this.getOrCreate();
            self.m_128365_(key, (Tag)newTag);
        }, sub);
    }

    public ItemListTag getSubList(String key, int type) {
        ListTag sub = null;
        if (this.tag != null && this.tag.m_128425_(key, 9)) {
            sub = this.tag.m_128437_(key, type);
        }
        return new ItemListTag(this.stack, () -> {
            CompoundTag self = this.getOrCreate();
            ListTag next = self.m_128437_(key, type);
            if (!self.m_128441_(key)) {
                self.m_128365_(key, (Tag)next);
            }
            return next;
        }, newTag -> {
            CompoundTag self = this.getOrCreate();
            self.m_128365_(key, (Tag)newTag);
        }, sub);
    }
}

