/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.capability.player;

import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

@SerialClass
public class PlayerCapToClient
extends SerialPacketBase {
    @SerialClass.SerialField
    public Action action;
    @SerialClass.SerialField
    public ResourceLocation holderID;
    @SerialClass.SerialField
    public CompoundTag tag;
    @SerialClass.SerialField
    public UUID playerID;

    @Deprecated
    public PlayerCapToClient() {
    }

    public <T extends PlayerCapabilityTemplate<T>> PlayerCapToClient(Action action, PlayerCapabilityHolder<T> holder, T handler) {
        this.action = action;
        this.holderID = holder.id;
        this.tag = action.server.apply(handler);
        this.playerID = handler.player.m_20148_();
    }

    public void handle(NetworkEvent.Context context) {
        if (this.action != Action.ALL && this.action != Action.CLONE && !Proxy.getClientPlayer().m_6084_()) {
            return;
        }
        PlayerCapabilityHolder<?> holder = PlayerCapabilityHolder.INTERNAL_MAP.get(this.holderID);
        this.action.client.accept(holder, this);
    }

    public static enum Action {
        ALL(m -> TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)m), (holder, packet) -> holder.cacheSet(packet.tag, false)),
        CLONE(m -> TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)m), (holder, packet) -> holder.cacheSet(packet.tag, true)),
        TRACK(m -> TagCodec.toTag((CompoundTag)new CompoundTag(), m.getClass(), (Object)m, SerialClass.SerialField::toTracking), (holder, packet) -> holder.updateTracked(packet.tag, Proxy.getClientWorld().m_46003_(packet.playerID)));

        public final Function<Object, CompoundTag> server;
        public final BiConsumer<PlayerCapabilityHolder<?>, PlayerCapToClient> client;

        private Action(Function<Object, CompoundTag> server, BiConsumer<PlayerCapabilityHolder<?>, PlayerCapToClient> client) {
            this.server = server;
            this.client = client;
        }
    }
}

