/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.message;

import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.common.entity.IHurtableMultipart;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UPMessageHurtMultipart {
    public int part;
    public int parent;
    public float damage;
    public String damageType;

    public UPMessageHurtMultipart(int part, int parent, float damage) {
        this.part = part;
        this.parent = parent;
        this.damage = damage;
        this.damageType = "";
    }

    public UPMessageHurtMultipart(int part, int parent, float damage, String damageType) {
        this.part = part;
        this.parent = parent;
        this.damage = damage;
        this.damageType = damageType;
    }

    public static UPMessageHurtMultipart read(FriendlyByteBuf buf) {
        return new UPMessageHurtMultipart(buf.readInt(), buf.readInt(), buf.readFloat(), buf.m_130277_());
    }

    public static void write(UPMessageHurtMultipart message, FriendlyByteBuf buf) {
        buf.writeInt(message.part);
        buf.writeInt(message.parent);
        buf.writeFloat(message.damage);
        buf.m_130070_(message.damageType);
    }

    public static class Handler {
        public static void handle(UPMessageHurtMultipart message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = UnusualPrehistory.PROXY.getClientSidePlayer();
            }
            if (player != null && player.m_9236_() != null) {
                Entity part = player.m_9236_().m_6815_(message.part);
                Entity parent = player.m_9236_().m_6815_(message.parent);
                if (part instanceof IHurtableMultipart && parent instanceof LivingEntity) {
                    ((IHurtableMultipart)part).onAttackedFromServer((LivingEntity)parent, message.damage, part.m_269291_().m_269333_((LivingEntity)player));
                }
                if (part == null && parent != null && parent.isMultipartEntity()) {
                    parent.m_6469_(parent.m_269291_().m_269333_((LivingEntity)player), message.damage);
                }
            }
        }
    }
}

