/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.message;

import com.peeko32213.unusualprehistory.common.entity.IAttackEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttackInputMessage {
    public int key;
    public static final Logger LOGGER = LogManager.getLogger();

    public AttackInputMessage(int key) {
        this.key = key;
    }

    public AttackInputMessage(FriendlyByteBuf buf) {
        this.key = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.key);
    }

    public static void handle(AttackInputMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Entity vehicle = player.m_20202_();
            if (vehicle instanceof IAttackEntity) {
                TamableAnimal animal;
                IAttackEntity attackEntity = (IAttackEntity)vehicle;
                if (vehicle instanceof TamableAnimal && (animal = (TamableAnimal)vehicle).m_21824_() && animal.m_6688_() == player && attackEntity.getAttackCooldown() <= 0) {
                    attackEntity.performAttack();
                    attackEntity.setAttackCooldown(attackEntity.getMaxAttackCooldown());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

