/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.util.GroomGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.PounceGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.SmilodonAttackGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntitySmilodon
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntitySmilodon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntitySmilodon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_GROOM = SynchedEntityData.m_135353_(EntitySmilodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GROOM_1 = SynchedEntityData.m_135353_(EntitySmilodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GROOM_2 = SynchedEntityData.m_135353_(EntitySmilodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Ingredient temptationItems;
    private static final RawAnimation SMILO_GROOM_1 = RawAnimation.begin().thenLoop("animation.smilodon.groom_1");
    private static final RawAnimation SMILO_GROOM_2 = RawAnimation.begin().thenLoop("animation.smilodon.groom_2");
    private static final RawAnimation SMILO_SPRINT = RawAnimation.begin().thenLoop("animation.smilodon.sprint");
    private static final RawAnimation SMILO_SNEAK = RawAnimation.begin().thenLoop("animation.smilodon.sneak");
    private static final RawAnimation SMILO_MOVE = RawAnimation.begin().thenLoop("animation.smilodon.move");
    private static final RawAnimation SMILO_SWIM = RawAnimation.begin().thenLoop("animation.smilodon.swim");
    private static final RawAnimation SMILO_IDLE = RawAnimation.begin().thenLoop("animation.smilodon.idle");
    private static final RawAnimation SMILO_BITE = RawAnimation.begin().thenLoop("animation.smilodon.bite");
    public int groomTimer;

    public EntitySmilodon(EntityType<? extends EntityBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 3.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GroomGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new SmilodonAttackGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PounceGoal(this, 5));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 25.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(UPTags.SMILODON_TARGETS)));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.groomTimer-- < 0) {
            this.groomTimer = 6000;
            this.setCanGroom(true);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.SMILODON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.SMILODON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.SMILODON_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12361_, 0.1f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_GROOM, (Object)false);
        this.f_19804_.m_135372_(GROOM_1, (Object)false);
        this.f_19804_.m_135372_(GROOM_2, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("canGroom", this.canGroom());
        compound.m_128379_("groom1", this.groom1());
        compound.m_128379_("groom2", this.groom2());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCanGroom(compound.m_128471_("canGroom"));
        this.setGroom1(compound.m_128471_("groom1"));
        this.setGroom2(compound.m_128471_("groom2"));
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public boolean canGroom() {
        return (Boolean)this.f_19804_.m_135370_(CAN_GROOM);
    }

    public void setCanGroom(boolean canGroom) {
        this.f_19804_.m_135381_(CAN_GROOM, (Object)canGroom);
    }

    public boolean groom1() {
        return (Boolean)this.f_19804_.m_135370_(GROOM_1);
    }

    public void setGroom1(boolean groom1) {
        this.f_19804_.m_135381_(GROOM_1, (Object)groom1);
    }

    public boolean groom2() {
        return (Boolean)this.f_19804_.m_135370_(GROOM_1);
    }

    public void setGroom2(boolean groom2) {
        this.f_19804_.m_135381_(GROOM_2, (Object)groom2);
    }

    public boolean canGroom(EntitySmilodon pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (pOtherAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.canGroom() && pOtherAnimal.canGroom();
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.8) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d0 == 2.5) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    public boolean m_20161_() {
        return this.m_6047_() || super.m_20161_();
    }

    public double m_20968_(@Nullable Entity lookingEntity) {
        if (this.m_6047_()) {
            return 0.2;
        }
        return super.m_20968_(lookingEntity);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_);
    }

    protected <E extends EntitySmilodon> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.groom1() && !this.m_6069_()) {
            event.setAndContinue(SMILO_GROOM_1);
            event.getController().setAnimationSpeed(2.5);
            return PlayState.CONTINUE;
        }
        if (this.groom2() && !this.m_6069_()) {
            event.setAndContinue(SMILO_GROOM_2);
            event.getController().setAnimationSpeed(2.5);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_()) {
            if (this.m_20142_() && !this.m_6069_()) {
                event.setAndContinue(SMILO_SPRINT);
                event.getController().setAnimationSpeed(2.5);
                return PlayState.CONTINUE;
            }
            if (this.m_6047_() && !this.m_6069_()) {
                event.setAndContinue(SMILO_SNEAK);
                event.getController().setAnimationSpeed((double)0.8f);
                return PlayState.CONTINUE;
            }
            event.setAndContinue(SMILO_MOVE);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.setAndContinue(SMILO_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(SMILO_IDLE);
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    protected <E extends EntitySmilodon> PlayState attackController(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
            return event.setAndContinue(SMILO_BITE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 10, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 0, this::attackController)});
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    static class SmilodonStalkGoal
    extends Goal {
        protected final PathfinderMob mob;
        private double speedModifier = 0.5;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;

        public SmilodonStalkGoal(PathfinderMob pathfinderMob) {
            this.mob = pathfinderMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_6162_()) {
                return false;
            }
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.m_20270_((Entity)target) > 12.0f ? 0.5 : 1.7;
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.m_20270_((Entity)target) > 12.0f ? 0.5 : 1.7;
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double d = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.mob.m_21574_().m_148306_((Entity)target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = target.m_20185_();
                this.pathedTargetY = target.m_20186_();
                this.pathedTargetZ = target.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(target, d);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d && this.ticksUntilNextAttack <= 0) {
                this.mob.m_6858_(false);
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)enemy);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.mob.m_20205_() * 0.9f * (this.mob.m_20205_() * 0.9f) + attackTarget.m_20205_();
        }
    }
}

