/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.msc.part.EntityBrachiosaurusPart;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRideGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityBrachiosaurus
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Boolean> LAUNCHING = SynchedEntityData.m_135353_(EntityBrachiosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> HEAD_HEIGHT = SynchedEntityData.m_135353_(EntityBrachiosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityBrachiosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityBrachiosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityBrachiosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float prevHeadHeight = 0.0f;
    private int headPeakCooldown = 0;
    public final EntityBrachiosaurusPart neck;
    public final EntityBrachiosaurusPart[] theEntireNeck;
    public final EntityBrachiosaurusPart[] allParts;
    private int ridingTime = 0;
    private int entityToLaunchId = -1;
    private int shakeCooldown = 0;
    private int footPrintCooldown = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation BRACHI_LAUNCH = RawAnimation.begin().thenLoop("animation.brachiosaurus.launch");
    private static final RawAnimation BRACHI_WALK = RawAnimation.begin().thenLoop("animation.brachiosaurus.walk");
    private static final RawAnimation BRACHI_SWIM = RawAnimation.begin().thenLoop("animation.brachiosaurus.swim");
    private static final RawAnimation BRACHI_ATTACK = RawAnimation.begin().thenPlay("animation.brachiosaurus.attack");
    private static final RawAnimation BRACHI_IDLE = RawAnimation.begin().thenPlay("animation.brachiosaurus.idle");

    public EntityBrachiosaurus(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.neck = new EntityBrachiosaurusPart(this, 3.0f, 9.3f);
        this.theEntireNeck = new EntityBrachiosaurusPart[]{this.neck};
        this.allParts = new EntityBrachiosaurusPart[]{this.neck};
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 10.5).m_22268_(Attributes.f_22282_, 2.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BrachiMeleeAttackGoal(this, 1.3f, true));
        this.f_21345_.m_25352_(3, (Goal)new CustomRideGoal((PathfinderMob)this, 1.2, false){

            @Override
            public boolean shouldMoveForward() {
                return true;
            }

            @Override
            public boolean shouldMoveBackwards() {
                return false;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42028_}), false));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (this.isSaddled()) {
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof Player)) continue;
                return (Player)passenger;
            }
        }
        return null;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        pPassenger.m_6034_(this.m_20185_() + (double)(-1.5f * ySin), this.m_20186_() + this.m_6048_() + pPassenger.m_6049_() - (double)0.1f, this.m_20189_() - (double)(-1.5f * yCos));
    }

    public double m_6048_() {
        return 15.3;
    }

    public boolean m_5829_() {
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (item == Items.f_42450_ && !this.isSaddled() && !this.m_6162_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.setSaddled(true);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_42574_ && this.isSaddled()) {
            this.setSaddled(false);
            this.m_19998_((ItemLike)Items.f_42450_);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemstack) && this.isSaddled() && !player.m_6144_()) {
            if (this.notClientSide()) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean notClientSide() {
        return !this.m_9236_().f_46443_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD_HEIGHT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LAUNCHING, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag p_31808_) {
        super.m_7380_(p_31808_);
    }

    @Override
    public void m_7378_(CompoundTag p_31795_) {
        super.m_7378_(p_31795_);
    }

    public boolean isLaunching() {
        return (Boolean)this.f_19804_.m_135370_(LAUNCHING);
    }

    public void setLaunching(boolean charging) {
        this.f_19804_.m_135381_(LAUNCHING, (Object)charging);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled() && !this.m_9236_().f_46443_) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
        this.setSaddled(false);
    }

    public int m_8132_() {
        return 50;
    }

    public int m_8085_() {
        return 50;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.BRACHI_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.BRACHI_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.BRACHI_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.BRACHI_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)UPSounds.BRACHI_TOSS.get();
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return true;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return true;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return blockState.m_60734_() != Blocks.f_50571_ || blockState.m_204336_(BlockTags.f_13035_);
    }

    @Override
    public void m_8119_() {
        Object passenger;
        super.m_8119_();
        this.prevHeadHeight = this.getHeadHeight();
        float neckBase = 5.5f;
        if (!this.m_21525_()) {
            int l;
            Vec3[] avector3d = new Vec3[this.allParts.length];
            for (int j = 0; j < this.allParts.length; ++j) {
                this.allParts[j].collideWithNearbyEntities();
                avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
            }
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            float neckContraction = 0.3f * Math.abs(this.getHeadHeight() / 3.0f) + 0.5f * Math.abs(this.getHeadYaw(0.0f) / 50.0f);
            for (l = 0; l < this.theEntireNeck.length; ++l) {
                float f = (float)l / (float)this.theEntireNeck.length;
                float f1 = -(2.2f + (float)l - f * neckContraction);
                float f2 = Mth.m_14031_((float)(yaw + (float)Math.toRadians(f * this.getHeadYaw(0.0f)))) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                float f3 = Mth.m_14089_((float)(yaw + (float)Math.toRadians(f * this.getHeadYaw(0.0f)))) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                this.setPartPosition(this.theEntireNeck[l], f2 * f1, (double)neckBase + Math.sin((double)f * Math.PI * 0.5) * (double)(this.getHeadHeight() * -11.1f), -f3 * f1);
            }
            for (l = 0; l < this.allParts.length; ++l) {
                this.allParts[l].f_19854_ = avector3d[l].f_82479_;
                this.allParts[l].f_19855_ = avector3d[l].f_82480_;
                this.allParts[l].f_19856_ = avector3d[l].f_82481_;
                this.allParts[l].f_19790_ = avector3d[l].f_82479_;
                this.allParts[l].f_19791_ = avector3d[l].f_82480_;
                this.allParts[l].f_19792_ = avector3d[l].f_82481_;
            }
        }
        if (this.entityToLaunchId != -1 && this.m_6084_()) {
            Entity launch = this.m_9236_().m_6815_(this.entityToLaunchId);
            this.m_20153_();
            this.entityToLaunchId = -1;
            if (launch != null && !launch.m_20159_() && launch instanceof LivingEntity) {
                this.m_5496_((SoundEvent)UPSounds.BRACHI_TOSS.get(), 0.5f, 0.5f);
                launch.m_146884_(this.m_146892_().m_82520_(0.0, 1.0, 0.0));
                float rot = 180.0f + this.m_146908_();
                float strength = (float)((double)this.getLaunchStrength() * (1.0 - ((LivingEntity)launch).m_21133_(Attributes.f_22278_)));
                float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
                float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
                if (!((double)strength <= 0.0)) {
                    launch.f_19812_ = true;
                    Vec3 vec3 = this.m_20184_();
                    Vec3 vec31 = vec3.m_82549_(new Vec3((double)x, 0.0, (double)z).m_82541_().m_82490_((double)strength));
                    launch.m_20334_(vec31.f_82479_, (double)strength, vec31.f_82481_);
                }
            }
        }
        if (this.isLaunching() && (passenger = this.m_6688_()) instanceof LivingEntity) {
            this.entityToLaunchId = passenger.m_19879_();
            this.setLaunching(false);
            for (Entity rider : this.m_20197_()) {
                if (!(rider instanceof Player)) continue;
                Player player = (Player)rider;
                player.m_7292_(new MobEffectInstance((MobEffect)UPEffects.BRACHI_PROTECTION.get(), 200));
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_20160_()) {
                ++this.ridingTime;
                if (this.ridingTime >= this.getMaxRidingTime()) {
                    this.setLaunching(true);
                    this.isLaunching();
                }
            } else {
                this.ridingTime = 0;
                this.setLaunching(false);
            }
            if (this.m_6084_() && this.ridingTime > 0 && this.m_20184_().m_165925_() > 0.1 && this.isLaunching()) {
                for (Entity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0))) {
                    if (entity instanceof EntityBrachiosaurus || entity.m_20365_((Entity)this)) continue;
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f + this.f_19796_.m_188501_() * 3.0f);
                    if (!entity.m_20096_()) continue;
                    double d0 = entity.m_20185_() - this.m_20185_();
                    double d1 = entity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    float f = 0.5f;
                    entity.m_5997_(d0 / d2 * (double)f, (double)f, d1 / d2 * (double)f);
                }
            }
        }
        if (this.headPeakCooldown == 0) {
            float low = this.getLowHeadHeight();
            this.setHeadHeight(this.getHeadHeight() + (0.5f + (this.getLowHeadHeight() + this.getHighHeadHeight(low)) / 2.0f - this.getHeadHeight()) * 0.2f);
        } else if (this.getMaxFluidHeight() <= (double)(this.m_20206_() * 0.5f) && this.getMaxFluidHeight() >= (double)(this.m_20206_() * 0.25f)) {
            float mot = (float)this.m_20184_().m_82556_();
            this.setHeadHeight(Mth.m_14036_((float)(this.getHeadHeight() + 0.1f - 0.2f * mot), (float)0.0f, (float)2.0f));
            this.headPeakCooldown = 5;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_() && !this.m_20069_() && this.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI.get()).booleanValue()) {
            double brachiShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_RANGE.get();
            int brachiShakeAmp = (Integer)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_AMPLIFIER.get();
            float brachiMoveSoundVolume = ((Float)UnusualPrehistoryConfig.BRACHI_SOUND_VOLUME.get()).floatValue();
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(brachiShakeRange));
            for (LivingEntity e : list) {
                if (e instanceof EntityBrachiosaurus || !e.m_6084_()) continue;
                e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 20, brachiShakeAmp, false, false, false));
                this.m_5496_((SoundEvent)UPSounds.BRACHI_STEP.get(), brachiMoveSoundVolume, 0.4f);
            }
            this.shakeCooldown = 40;
        }
        --this.shakeCooldown;
    }

    private float getLaunchStrength() {
        return 5.0f;
    }

    private int getMaxRidingTime() {
        return 40;
    }

    private double getMaxFluidHeight() {
        return 11.5;
    }

    public float getLowHeadHeight() {
        float checkAt;
        for (checkAt = 0.0f; checkAt > -3.0f && !this.isHeadInWall((float)this.m_20186_() + checkAt); checkAt -= 0.2f) {
        }
        return checkAt;
    }

    public float getHighHeadHeight(float low) {
        float checkAt;
        for (checkAt = 3.0f; checkAt > 0.0f && !this.isHeadInWall((float)this.m_20186_() + checkAt); checkAt -= 0.2f) {
        }
        return checkAt;
    }

    public boolean isHeadInWall(float offset) {
        if (this.f_19794_) {
            return false;
        }
        float f = 0.8f;
        Vec3 vec3 = new Vec3(this.neck.m_20185_(), (double)offset, this.neck.m_20189_());
        AABB axisalignedbb = AABB.m_165882_((Vec3)vec3, (double)f, (double)1.0E-6, (double)f);
        return this.m_9236_().m_45556_(axisalignedbb).filter(Predicate.not(BlockBehaviour.BlockStateBase::m_60795_)).anyMatch(p_185969_ -> {
            BlockPos blockpos = BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_);
            return p_185969_.m_60828_((BlockGetter)this.m_9236_(), blockpos) && Shapes.m_83157_((VoxelShape)p_185969_.m_60812_((BlockGetter)this.m_9236_(), blockpos).m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_), (VoxelShape)Shapes.m_83064_((AABB)axisalignedbb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public float getHeadHeight() {
        return Mth.m_14036_((float)((Float)this.f_19804_.m_135370_(HEAD_HEIGHT)).floatValue(), (float)-3.0f, (float)3.0f);
    }

    public void setHeadHeight(float height) {
        this.f_19804_.m_135381_(HEAD_HEIGHT, (Object)Float.valueOf(Mth.m_14036_((float)height, (float)-3.0f, (float)3.0f)));
    }

    public float getHeadYaw(float interp) {
        float f;
        if (interp == 0.0f) {
            f = this.m_6080_() - this.f_20883_;
        } else {
            float yBodyRot1 = this.f_20884_ + (this.f_20883_ - this.f_20884_) * interp;
            float yHeadRot1 = this.f_20886_ + (this.m_6080_() - this.f_20886_) * interp;
            f = yHeadRot1 - yBodyRot1;
        }
        return Mth.m_14036_((float)Mth.m_14177_((float)f), (float)-50.0f, (float)50.0f);
    }

    private void setPartPosition(EntityBrachiosaurusPart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public boolean attackEntityPartFrom(EntityBrachiosaurusPart part, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    public void scaleParts() {
        for (EntityBrachiosaurusPart parts : this.allParts) {
            float prev = parts.scale;
            float f = parts.scale = this.m_6162_() ? 0.5f : 1.0f;
            if (prev == parts.scale) continue;
            parts.m_6210_();
        }
    }

    public void m_146758_(int pAmount) {
        this.scaleParts();
        super.m_146758_(pAmount);
    }

    public void m_8107_() {
        BlockState blockstate;
        AABB axisalignedbb;
        boolean flag;
        super.m_8107_();
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            flag = false;
            axisalignedbb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                blockstate = this.m_9236_().m_8055_(blockpos);
                if (!blockstate.m_204336_(UPTags.PASSIVE_BRACHI_BREAKABLES)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_5912_()) {
            flag = false;
            axisalignedbb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                blockstate = this.m_9236_().m_8055_(blockpos);
                if (!blockstate.m_204336_(UPTags.ANGRY_BRACHI_BREAKABLES)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    protected <E extends EntityBrachiosaurus> PlayState Controller(AnimationState<E> event) {
        int animState = this.getAnimationState();
        if (!this.isFromBook()) {
            switch (animState) {
                case 21: {
                    return event.setAndContinue(BRACHI_ATTACK);
                }
            }
            if (this.isLaunching()) {
                event.setAndContinue(BRACHI_LAUNCH);
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            if (this.m_20069_()) {
                event.setAndContinue(BRACHI_SWIM);
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            if (event.isMoving() && !this.m_20069_()) {
                event.setAndContinue(BRACHI_WALK);
                event.getController().setAnimationSpeed(1.5);
                return PlayState.CONTINUE;
            }
            if (!this.m_20069_()) {
                event.setAndContinue(BRACHI_IDLE);
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    static class BrachiMeleeAttackGoal
    extends Goal {
        protected final EntityBrachiosaurus mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public BrachiMeleeAttackGoal(EntityBrachiosaurus p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 21: {
                    this.tickStompAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            int r;
            if (distance <= reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_217043_().m_188503_(2048)) <= 600) {
                this.mob.setAnimationState(21);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickStompAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.preformStompAttack();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void preformStompAttack() {
            Vec3 pos = this.mob.m_20182_();
            HitboxHelper.LargeAttack(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 25.0f, 1.0f, (PathfinderMob)this.mob, pos, 7.0, -1.5707963267948966, 1.5707963267948966, -1.0, 3.0);
            if (this.mob.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI.get()).booleanValue()) {
                double brachiShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_RANGE.get();
                List list = this.mob.m_9236_().m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(brachiShakeRange));
                for (LivingEntity e : list) {
                    if (e instanceof EntityBrachiosaurus || !e.m_6084_()) continue;
                    e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 50, 6, false, false, false));
                    this.mob.m_5496_((SoundEvent)UPSounds.BRACHI_STEP.get(), 2.0f, 0.4f);
                }
                this.mob.shakeCooldown = 10;
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

