/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.peeko32213.unusualprehistory.common.data.ItemWeightedPairCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RollableItemCodec {
    public static Codec<RollableItemCodec> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.optionalFieldOf("rolls", (Object)1).forGetter(r -> r.rolls), (App)ItemWeightedPairCodec.CODEC.listOf().fieldOf("entries").forGetter(e -> e.entries)).apply((Applicative)inst, RollableItemCodec::new));
    private int rolls;
    private List<ItemWeightedPairCodec> entries;

    public RollableItemCodec(int rolls, List<ItemWeightedPairCodec> entries) {
        this.rolls = rolls;
        this.entries = entries;
    }

    public int getRolls() {
        return this.rolls;
    }

    public List<ItemWeightedPairCodec> getEntries() {
        return this.entries;
    }

    public Map<ItemStack, Integer> getRandomItem(RandomSource random, List<ItemWeightedPairCodec> entries) {
        List<ItemWeightedPairCodec> outputs = entries;
        Item outputItem = null;
        int totalWeight = 0;
        for (ItemWeightedPairCodec itemWeightedPair : outputs) {
            totalWeight += itemWeightedPair.getWeight();
        }
        int randomNr = random.m_188503_(totalWeight);
        int cumulativeWeight = 0;
        int outputCount = 0;
        for (ItemWeightedPairCodec itemWeightedPair : outputs) {
            if (randomNr >= (cumulativeWeight += itemWeightedPair.getWeight())) continue;
            outputItem = itemWeightedPair.getItem();
            outputCount = itemWeightedPair.getAmount();
            break;
        }
        HashMap<ItemStack, Integer> outPut = new HashMap<ItemStack, Integer>();
        ItemStack outputStack = new ItemStack(outputItem);
        if (outputStack == null) {
            HashMap<ItemStack, Integer> failMap = new HashMap<ItemStack, Integer>();
            failMap.put(ItemStack.f_41583_, 1);
            return failMap;
        }
        outPut.put(outputStack, outputCount);
        return outPut;
    }

    public void dropItem(Level level, BlockPos pos, RollableItemCodec rollableItemCodec) {
        for (int i = 0; i < rollableItemCodec.getRolls(); ++i) {
            Map<ItemStack, Integer> itemCount = this.getRandomItem(level.f_46441_, rollableItemCodec.getEntries());
            if (itemCount.isEmpty()) continue;
            for (Map.Entry<ItemStack, Integer> itemEntry : itemCount.entrySet()) {
                for (int count = 0; count < itemEntry.getValue(); ++count) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemEntry.getKey());
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
    }
}

